/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.validator.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.validate.ErrorLevel;
import kd.swc.hcdm.business.validator.bean.ValidateResult;

public class ValidateContext<T>
implements Serializable {
    private static final long serialVersionUID = -2613659625185553132L;
    private List<ValidateResult> results = new ArrayList<ValidateResult>(10);
    private T data;
    private boolean stop = false;

    public ValidateContext(T data) {
        this.data = data;
    }

    public List<ValidateResult> getResults() {
        return this.results;
    }

    public void setResults(List<ValidateResult> results) {
        this.results = results;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public List<ValidateResult> getResultsByLevel(ErrorLevel level) {
        return this.results.stream().filter(result -> result.getLevel().equals((Object)level)).collect(Collectors.toList());
    }

    public List<ValidateResult> getFatalErrorResults() {
        return this.getResultsByLevel(ErrorLevel.FatalError);
    }

    public List<ValidateResult> getWarningResults() {
        return this.getResultsByLevel(ErrorLevel.Warning);
    }

    public List<ValidateResult> getErrorResults() {
        return this.getResultsByLevel(ErrorLevel.Error);
    }
}

