/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.validator.bean;

import java.util.ArrayList;
import java.util.List;
import kd.swc.hcdm.business.validator.impl.Validator;

public class ValidatorTree {
    private ValidatorNode root = new ValidatorNode(null);
    private List<ValidatorNode> allNodes = null;

    public ValidatorTree() {
        this.root.isRoot = true;
        this.allNodes = new ArrayList<ValidatorNode>(10);
    }

    public ValidatorNode getRoot() {
        return this.root;
    }

    public List<ValidatorNode> getAllNodes() {
        return this.allNodes;
    }

    public ValidatorNode addNode(ValidatorNode parentNode, ValidatorNode newNode) {
        return this.addNode(parentNode, newNode, null);
    }

    public ValidatorNode addNode(ValidatorNode parentNode, ValidatorNode newNode, Integer index) {
        ValidatorNode curParentNode = parentNode == null ? this.root : parentNode;
        List<ValidatorNode> curChilds = curParentNode.getChild();
        if (index == null) {
            curChilds.add(newNode);
        } else {
            curChilds.add(index, newNode);
        }
        newNode.parent = curParentNode;
        this.allNodes.add(newNode);
        return newNode;
    }

    public static class ValidatorNode {
        private ValidatorNode parent;
        private List<ValidatorNode> child = new ArrayList<ValidatorNode>(10);
        private Validator validator;
        private boolean isRoot = false;

        public ValidatorNode(Validator validator) {
            this.validator = validator;
        }

        public ValidatorNode getParent() {
            return this.parent;
        }

        public List<ValidatorNode> getChild() {
            return this.child;
        }

        public Validator getValidator() {
            return this.validator;
        }

        public boolean isRoot() {
            return this.isRoot;
        }
    }
}

