/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.vo.salarystandard;

import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetFieldParamEvent;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;

public class FieldColumnWidthMapping {
    private HRPluginProxy<IStdTableExtPlugin> proxy = HRPlugInProxyFactory.create((Object)new DefaultStdTableExtPlugin(), IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#onGetFieldColumnWidth", null);
    private static Map<String, String> stdItemStdRankMap = new HashMap<String, String>(32);
    private static Map<String, String> stdItemSpRankMap = new HashMap<String, String>(32);
    private static Map<String, String> spItemStdRankMap = new HashMap<String, String>(32);
    private static Map<String, String> spItemSpRankMap = new HashMap<String, String>(32);
    private static final String var_two_tpl = "%s-%d";
    private static final String var_three_tpl = "%s-%d-%d";
    private static final String var_four_tpl = "%s-%d-%d-%d";

    public static FieldColumnWidthMapping getInstance() {
        return new FieldColumnWidthMapping();
    }

    public String getFieldColWidthForGroupItemExt(SalaryStandardTypeEnum type, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        String width = FieldColumnWidthMapping.getDefaultFieldColWidthForGroupItem(type, item, rank, seq);
        OnGetFieldParamEvent evt = new OnGetFieldParamEvent((Object)type);
        evt.setType(type);
        evt.setItemEntity(item);
        evt.setRankEntity(rank);
        evt.setSeq(seq);
        this.proxy.callAfter(plugin -> {
            plugin.onGetFieldColumnWidth(evt);
            return null;
        });
        if (evt.getFieldWidth() != null) {
            width = evt.getFieldWidth();
        }
        return width;
    }

    public static String getDefaultFieldColWidthForGroupItem(SalaryStandardTypeEnum type, SalaryStdItemEntity item, SalaryRankEntity rank, int seq) {
        SalaryItemLabelEnum itemLabel = item.getItemLabel();
        SalaryRankLabelEnum rankLabel = rank.getRankLabel();
        String width = null;
        width = itemLabel.equals((Object)SalaryItemLabelEnum.STANDARD) ? (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? stdItemStdRankMap.get(String.format(var_two_tpl, type.getCode(), seq)) : stdItemSpRankMap.get(String.format(var_three_tpl, type.getCode(), rank.getRankIdentity(), seq))) : (rankLabel.equals((Object)SalaryRankLabelEnum.STANDARD) ? spItemStdRankMap.get(String.format(var_three_tpl, type.getCode(), item.getItemIdentity(), seq)) : spItemSpRankMap.get(String.format(var_four_tpl, type.getCode(), item.getItemIdentity(), rank.getRankIdentity(), seq)));
        if (width == null) {
            width = "120";
        }
        return width;
    }

    static {
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStdGridFieldSeqEnum.MIDDLE_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStdGridFieldSeqEnum.MAX_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStdGridFieldSeqEnum.MAX_SEQ.getCode()), "120");
        stdItemStdRankMap.put(String.format(var_two_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStdGridFieldSeqEnum.SALARY_COUNT_SEQ.getCode()), "120");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_WIDTH, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_GEARDIFFERENCE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_OVERLAP, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        stdItemSpRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_RANK_ISOMETRIC, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "130");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.SALARYCOUNT.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "120");
        spItemStdRankMap.put(String.format(var_three_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "130");
        spItemSpRankMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "115");
        spItemSpRankMap.put(String.format(var_four_tpl, SalaryStandardTypeEnum.BROADBAND.getCode(), SalaryStandardConstants.S_ITEM_TOTAL, SalaryStandardConstants.S_RANK_MEDIANVALUE, SalaryStdGridFieldSeqEnum.MIN_SEQ.getCode()), "130");
    }
}

