/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web;

import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public abstract class AbstractHcssDyFormPlugin
extends SWCDataBaseEdit
implements AbstractHcssFormPlugin {
    private static final String CLOSEBACK = "closeBack";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean cancelDataRight = SWCPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView());
        if (cancelDataRight) {
            args.setCancel(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (model.getDataChanged()) {
            ((FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE)).showOperationResultConfirm(this.getView(), new ConfirmCallBackListener(CLOSEBACK));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CLOSEBACK.equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.setDataChanged(false);
            this.getView().close();
        }
    }
}

