/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.swc.hcss.business.handle.action.FieldsHandle;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssBaseFormPlugin;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AbstractIncomeProofBillPlugin
extends AbstractHcssBaseFormPlugin
implements IncomeProofCommon,
BeforeF7SelectListener {
    protected IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);
    protected IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    public void afterLoadData(EventObject e) {
        this.afterLoadDataInitData();
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAttachmentHandle();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.submitAfterDoOperation(afterDoOperationEventArgs);
        this.unsubmitAfterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        DynamicObject billData = this.getModel().getDataEntity();
        if ("applyreason".equals(name) || "printtpl".equals(name) || "isuploadtpl".equals(name) || "issuetype".equals(name) || "econtpl".equals(name) || "receiveway".equals(name)) {
            MutableGraph fieldControlGraph = this.incomeProofBillService.getFieldControlGraph();
            IncomeBillControlDTO changeField = new IncomeBillControlDTO(name);
            changeField.setValue(newValue);
            LinkedHashMap resultMap = new LinkedHashMap(16);
            this.incomeProofBillService.fieldPropertyChanged(changeField, billData, fieldControlGraph, resultMap);
            ArrayList<IncomeBillControlDTO> controlList = new ArrayList<IncomeBillControlDTO>(resultMap.values());
            this.setFieldValue(controlList, true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        DynamicObject billData = this.getModel().getDataEntity();
        if ("applyreason".equals(key)) {
            DynamicObject employee = billData.getDynamicObject("employee");
            if (employee == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ee3\u7533\u8bf7\u5458\u5de5\u3002", (String)"AgentIncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            Set reasonIdSet = incomeTpl.getDynamicObjectCollection("reason").stream().map(data -> data.getLong("fbasedataid.id")).collect(Collectors.toSet());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", reasonIdSet));
        } else if ("printtpl".equals(key)) {
            this.printTplBeforeF7Select(beforeF7SelectEvent, billData);
        } else if ("receiveway".equals(key)) {
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)this.incomeProofTplService.getReceiveWayIds(incomeTpl)));
        }
    }

    private void setControlList(Boolean isCan, List<String> can, List<String> disCan, String fieldKey) {
        if (isCan == null) {
            return;
        }
        if (isCan.booleanValue()) {
            can.add(fieldKey);
        } else {
            disCan.add(fieldKey);
        }
    }

    private void setFieldValue(List<IncomeBillControlDTO> controlList, boolean isNeedSetValue) {
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        ArrayList<String> enable = new ArrayList<String>(10);
        ArrayList<String> disEnable = new ArrayList<String>(10);
        ArrayList<String> show = new ArrayList<String>(10);
        ArrayList<String> hide = new ArrayList<String>(10);
        ArrayList<String> must = new ArrayList<String>(10);
        ArrayList<String> notMust = new ArrayList<String>(10);
        for (IncomeBillControlDTO controlDTO : controlList) {
            String fieldKey = controlDTO.getFieldKey();
            Control control = this.getView().getControl(fieldKey);
            if (control instanceof FieldEdit) {
                if (isNeedSetValue) {
                    handle.setValue(this.getView(), fieldKey, controlDTO.getValue(), Boolean.FALSE);
                }
            } else if (control instanceof Label) {
                if (controlDTO.getValue() != null) {
                    handle.setLabValue(this.getView(), fieldKey, String.valueOf(controlDTO.getValue()));
                }
            } else if (control instanceof AttachmentPanel && (controlDTO.getValue() == null || !((Boolean)controlDTO.getValue()).booleanValue())) {
                AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanel");
                List attachmentAttachmentData = attachment.getAttachmentData();
                attachmentAttachmentData.forEach(arg_0 -> ((AttachmentPanel)attachment).remove(arg_0));
            }
            Boolean isEnable = controlDTO.getEnable();
            Boolean isVisible = controlDTO.getVisible();
            Boolean isMust = controlDTO.getMust();
            this.setControlList(isEnable, enable, disEnable, fieldKey);
            this.setControlList(isVisible, show, hide, fieldKey);
            this.setControlList(isMust, must, notMust, fieldKey);
        }
        handle.setEnable(this.getView(), enable, Boolean.TRUE);
        handle.setEnable(this.getView(), disEnable, Boolean.FALSE);
        handle.setVisible(this.getView(), show, Boolean.TRUE);
        handle.setVisible(this.getView(), hide, Boolean.FALSE);
        handle.setMustInput(this.getView(), must, Boolean.TRUE);
        handle.setMustInput(this.getView(), notMust, Boolean.FALSE);
    }

    private void afterLoadDataInitData() {
        DynamicObject dataBill = this.getModel().getDataEntity();
        this.setPersonInfo(dataBill);
        this.setIncomeInfoVisible();
        if (!dataBill.getBoolean("isuploadtpl") && dataBill.getDynamicObject("printtpl") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
        }
        MutableGraph fieldControlGraph = this.incomeProofBillService.getFieldControlGraph();
        IncomeBillControlDTO changeField = new IncomeBillControlDTO("applyreason");
        LinkedHashMap resultMap = new LinkedHashMap(16);
        this.incomeProofBillService.fieldInitData(changeField, dataBill, fieldControlGraph, resultMap);
        ArrayList<IncomeBillControlDTO> controlList = new ArrayList<IncomeBillControlDTO>(resultMap.values());
        this.setFieldValue(controlList, false);
    }

    protected void setPersonInfo(DynamicObject dataBill) {
        IFormView view = this.getView();
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setValueNotChanged(view, "headsculpture", (Object)dataBill.getString("person.headsculpture"));
        this.getModel().setDataChanged(false);
        this.setNotVisible(handle);
    }

    protected void setIncomeInfoVisible() {
        ArrayList<String> hideKey = new ArrayList<String>(10);
        String bizKey = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
        if (!SWCStringUtils.isEmpty((String)bizKey)) {
            String isShowIncome = (String)this.getView().getFormShowParameter().getCustomParam("isshowincomeinfo");
            if (!"1".equals(isShowIncome)) {
                hideKey.add("incomeinfo");
            }
        } else {
            hideKey.add("incomeinfo");
            this.setSplitContainerVisible();
        }
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), hideKey, Boolean.FALSE);
    }

    protected void setNotVisible(IViewHandle viewHandle) {
        DynamicObject dataBill = this.getModel().getDataEntity();
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorposition", "position"), Boolean.valueOf(dataBill.getDynamicObject("position") != null));
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorapadminorg", "adminorg"), Boolean.valueOf(dataBill.getDynamicObject("adminorg") != null));
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorapcompany", "company"), Boolean.valueOf(dataBill.getDynamicObject("company") != null));
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorapphone", "phone"), Boolean.valueOf(SWCStringUtils.isNotEmpty((String)dataBill.getString("percontact.phone"))));
    }

    protected void printTplBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject billData) {
        DynamicObject applyReason = billData.getDynamicObject("applyreason");
        if (applyReason == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc1\u660e\u7528\u9014\u3002", (String)"IncomeProofDetailPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        HashSet printIdSet = new HashSet(16);
        DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
        incomeTpl.getDynamicObjectCollection("entryentity").forEach(entry -> {
            DynamicObjectCollection reasonMul = entry.getDynamicObjectCollection("mulreasonentry");
            for (DynamicObject reason : reasonMul) {
                if (applyReason.getLong("id") != reason.getLong("fbasedataid.id")) continue;
                printIdSet.add(entry.getString("printtpl.id"));
                break;
            }
        });
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", printIdSet));
    }

    protected void afterCreateNewDataInitData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("person"));
        Long orgId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("org"));
        Long incomeTplId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("incometpl"));
        Map personInfoMap = this.incomeProofBillService.getPersonInfoMap(personId);
        viewHandle.setMultiValue(this.getView(), personInfoMap, Boolean.FALSE);
        viewHandle.setValueNotChanged(this.getView(), "incometpl", (Object)incomeTplId);
        viewHandle.setValueNotChanged(this.getView(), "org", (Object)orgId);
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorprinttpl", "flextips", "issueinfotipsflex", "issuetype", "issuenum", "receiveway", "mailinginfo"), Boolean.FALSE);
        DynamicObject dataBill = this.getModel().getDataEntity();
        DynamicObject incomeTpl = dataBill.getDynamicObject("incometpl");
        if (incomeTpl == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"IncomeProofDetailPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!incomeTpl.getBoolean("isuploadtpl")) {
            viewHandle.setVisible(this.getView(), Arrays.asList("isuploadtpl", "attachmentpanel"), Boolean.FALSE);
        } else {
            viewHandle.setVisible(this.getView(), Collections.singletonList("attachmentpanel"), Boolean.FALSE);
            viewHandle.setVisible(this.getView(), Collections.singletonList("isuploadtpl"), Boolean.TRUE);
        }
        viewHandle.setValueNotChanged(this.getView(), "headsculpture", (Object)dataBill.getString("person.headsculpture"));
        this.setNotVisible((IViewHandle)viewHandle);
        this.setIncomeInfoVisible();
    }

    private void setAttachmentHandle() {
        List dealAttachmentData;
        DynamicObject dataBill = this.getModel().getDataEntity();
        long billId = dataBill.getLong("id");
        FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("attachmentpanelhandle"), Boolean.FALSE);
        String billStatus = dataBill.getString("billstatus");
        if ("C".equals(billStatus) && "1".equals(dataBill.getString("issuetype")) && !(dealAttachmentData = this.incomeProofBillService.getDealAttachmentData(Long.valueOf(billId))).isEmpty()) {
            viewHandle.setVisible(this.getView(), Collections.singletonList("attachmentpanelhandle"), Boolean.TRUE);
            AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanelhandle");
            attachment.bindData(dealAttachmentData);
        }
    }

    private void setSplitContainerVisible() {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String auditStatus = dataEntity.getString("auditstatus");
        splitContainer.hidePanel(SplitDirection.right, "A".equalsIgnoreCase(auditStatus));
    }

    protected void previewIncomeProofBillPdf() {
        DynamicObject billBaseData = this.getModel().getDataEntity();
        String printTplId = billBaseData.getString("printtpl.id");
        if (SWCStringUtils.isEmpty((String)printTplId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().openUrl(this.incomeProofBillService.previewIncomeProofBillPdf(Long.valueOf(0L), printTplId));
    }

    protected void submitAfterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey) && null != (operationResult = afterDoOperationEventArgs.getOperationResult()) && operationResult.isSuccess()) {
            FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
            viewHandle.setVisible(this.getView(), Arrays.asList("flextips", "issueinfotipsflex"), Boolean.FALSE);
            this.setSplitContainerVisible();
        }
        this.setAttachmentHandle();
    }

    private void unsubmitAfterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if ("unsubmit".equals(operateKey) && null != (operationResult = afterDoOperationEventArgs.getOperationResult()) && operationResult.isSuccess()) {
            this.setSplitContainerVisible();
        }
    }
}

