/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcss.business.handle.action.FieldsHandle;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.income.AbstractIncomeProofBillPlugin;

public class AgentIncomeProofBillPlugin
extends AbstractIncomeProofBillPlugin {
    private static final Log LOGGER = LogFactory.getLog(AgentIncomeProofBillPlugin.class);

    public void afterCreateNewData(EventObject e) {
        FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Arrays.asList("personflex", "vectorprinttpl", "attachmentpanel", "isuploadtpl", "flextips", "mailinginfo", "incomeinfo", "issueinfotipsflex", "issuetype", "issuenum", "receiveway", "attachmentpanelhandle"), Boolean.FALSE);
        viewHandle.setValueNotChanged(this.getView(), "org", null);
        viewHandle.setMustInput(this.getView(), Collections.singletonList("printtpl"), Boolean.TRUE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("printtpl"), Boolean.TRUE);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit employee = (BasedataEdit)this.getView().getControl("employee");
        employee.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit printTplEntry = (BasedataEdit)this.getView().getControl("printtpl");
        printTplEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit applyReason = (BasedataEdit)this.getView().getControl("applyreason");
        applyReason.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit receiveWay = (BasedataEdit)this.getView().getControl("receiveway");
        receiveWay.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("employee".equals(key)) {
            Long curEmployeeId = this.incomeProofBillService.getCurPersonInfo().getOrDefault("employee", 0L);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "!=", (Object)curEmployeeId));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if ("employee".equals(name)) {
            if (newValue == null) {
                this.getView().invokeOperation("refresh");
            } else {
                if (oldValue != null) {
                    this.getView().invokeOperation("refresh");
                }
                FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
                Long personId = ((DynamicObject)newValue).getLong("person.id");
                Long orgId = this.incomeProofBillService.getPersonFileOrgId(personId);
                DynamicObject[] tplArray = this.incomeProofTplService.getAuditAndEnableDataArrayByOrg(orgId);
                if (tplArray == null || tplArray.length != 1) {
                    LOGGER.info("tpl size is not one,orgId is {}", (Object)orgId);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u5458\u5de5\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"AgentIncomeProofBillPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                    viewHandle.setValueNotChanged(this.getView(), "employee", null);
                    return;
                }
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                formShowParameter.setCustomParam("person", (Object)personId);
                formShowParameter.setCustomParam("incometpl", (Object)tplArray[0].getLong("sourcevid"));
                formShowParameter.setCustomParam("org", (Object)orgId);
                this.afterCreateNewDataInitData();
                viewHandle.setVisible(this.getView(), Collections.singletonList("personflex"), Boolean.TRUE);
                this.getView().updateView("name");
                this.getView().updateView("number");
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hcss_incomeproofbill".equals(formId)) {
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }
}

