/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssListPlugin;

public class IncomeProofBillList
extends AbstractHcssListPlugin
implements IncomeProofCommon {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    public void setFilter(SetFilterEvent e) {
        BillList source = (BillList)e.getSource();
        String billFormId = source.getBillFormId();
        if ("hcss_agentincomeproofbill".equals(billFormId)) {
            e.addCustomQFilter(new QFilter("datasource", "=", (Object)"2"));
            return;
        }
        e.addCustomQFilter(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
        e.addCustomQFilter(new QFilter("datasource", "=", (Object)"1"));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListView view = (ListView)this.getView();
        String billFormId = view.getBillFormId();
        if ("hcss_agentincomeproofbill".equals(billFormId)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            commonFilterColumns.forEach(filterColumn -> {
                String fieldName = filterColumn.getFieldName();
                if ("creator.id".equals(fieldName)) {
                    filterColumn.setDefaultValue(RequestContext.get().getCurrUserId() + "");
                }
            });
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        if ("printtpl.name".equals(fieldName)) {
            List enablePrintTplIds = this.incomeProofTplService.getEnablePrintTplIds();
            filters.add(new QFilter("id", "in", (Object)enablePrintTplIds));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListView view = (ListView)this.getView();
        String billFormId = view.getBillFormId();
        if ("hcss_agentincomeproofbill".equals(billFormId)) {
            this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE).setFixed(this.getView(), args.getListColumns(), Arrays.asList("billno", "person.name", "person.number"));
        } else {
            this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE).setFixed(this.getView(), args.getListColumns(), Collections.singletonList("billno"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("received".equals(operateKey) || "unsubmit".equals(operateKey) || "abandoned".equals(operateKey) || "unsubmit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

