/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.income.AbstractIncomeProofBillPlugin;

public class IncomeProofBillPlugin
extends AbstractIncomeProofBillPlugin {
    private static final Log LOGGER = LogFactory.getLog(IncomeProofBillPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit printTplEntry = (BasedataEdit)this.getView().getControl("printtpl");
        printTplEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit applyReason = (BasedataEdit)this.getView().getControl("applyreason");
        applyReason.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit receiveWay = (BasedataEdit)this.getView().getControl("receiveway");
        receiveWay.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        String formId = args.getFormShowParameter().getFormId();
        if ("hcss_agentincomeproofbill".equals(formId)) {
            return;
        }
        FormShowParameter formShowParameter = args.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW != status) {
            return;
        }
        Long personId = this.incomeProofBillService.getCurPersonInfo().getOrDefault("person", 0L);
        Long orgId = this.incomeProofBillService.getPersonFileOrgId(personId);
        DynamicObject[] tplArray = this.incomeProofTplService.getAuditAndEnableDataArrayByOrg(orgId);
        if (tplArray == null || tplArray.length != 1) {
            LOGGER.info("tpl size is not one,orgId is {}", (Object)orgId);
            args.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"IncomeProofDetailPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        formShowParameter.setCustomParam("person", (Object)personId);
        formShowParameter.setCustomParam("incometpl", (Object)tplArray[0].getLong("sourcevid"));
        formShowParameter.setCustomParam("org", (Object)orgId);
    }

    public void afterCreateNewData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hcss_agentincomeproofbill".equals(formId)) {
            return;
        }
        this.afterCreateNewDataInitData();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        String operateKey = source.getOperateKey();
        if ("previewprinttpl".equals(operateKey)) {
            this.previewIncomeProofBillPdf();
        } else if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            DynamicObject billBaseData = this.getModel().getDataEntity();
            BaseResult baseResult = this.incomeProofBillService.decorator(operateKey).beforeOperation(billBaseData, option, (AbstractFormPlugin)this);
            if (!baseResult.isSuccess()) {
                args.setCancel(true);
                FormHandle handle = (FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                handle.dealOperationResult(this.getView(), baseResult, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hcss_agentincomeproofbill".equals(formId)) {
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hcss_agentincomeproofbill".equals(formId)) {
            return;
        }
        super.beforeF7Select(beforeF7SelectEvent);
    }
}

