/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.AppliyReasonService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.web.incometpl.TplBaseOperation;
import kd.swc.hcss.common.common.IncomeProofTplCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssListPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IncomeProofTplList
extends AbstractHcssListPlugin
implements IncomeProofTplCommon {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);
    private AppliyReasonService appliyReasonService = (AppliyReasonService)DomainFactory.getInstance(AppliyReasonService.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if ("org.name".equals(fieldName)) {
                filterColumn.setDefaultValue("");
            }
        });
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        if ("reason.fbasedataid.name".equals(fieldName)) {
            filters.add(this.appliyReasonService.getDataRuleViewFilter());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_auditconfirmchange"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (formOp = source.getOperateKey()) {
            case "enable": 
            case "audit": 
            case "unaudit": 
            case "disable": {
                OperateOption option = source.getOption();
                String ignoreValue = option.getVariableValue("ignoreFlag", "");
                if (SWCStringUtils.equals((String)"1", (String)ignoreValue)) {
                    return;
                }
                ListSelectedRowCollection listSelectedData = ((ListView)this.getView()).getSelectedRows();
                TplBaseOperation operation = this.incomeProofTplService.decorator(formOp);
                BaseResult baseResult = operation.beforeOperation(listSelectedData);
                if (baseResult.isSuccess()) break;
                args.setCancel(true);
                String message = baseResult.getMessage();
                if (baseResult.isTip()) {
                    IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                    viewHandle.showSecondConfirm(this.getView(), message, new ConfirmCallBackListener(formOp, (IFormPlugin)this), null);
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "enable": 
            case "audit": 
            case "unaudit": 
            case "disable": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreFlag", "1");
                this.getView().invokeOperation(key, option);
                break;
            }
        }
    }
}

