/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterChangeMainOrgEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.MainOrgChangeListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.FieldsHandle;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.AppliyReasonService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.service.income.ReceiveWayService;
import kd.swc.hcss.business.web.incometpl.TplBaseOperation;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.common.IncomeProofTplCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssBaseFormPlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IncomeProofTplPlugin
extends AbstractHcssBaseFormPlugin
implements BeforeF7SelectListener,
MainOrgChangeListener,
IncomeProofTplCommon {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);
    private AppliyReasonService appliyReasonService = (AppliyReasonService)DomainFactory.getInstance(AppliyReasonService.class);
    private ReceiveWayService receiveWayService = (ReceiveWayService)DomainFactory.getInstance(ReceiveWayService.class);

    public void initialize() {
        MainOrgEdit mainOrgEdit;
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String mainOrgKey = dataEntityType.getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)mainOrgKey) && (mainOrgEdit = (MainOrgEdit)this.getView().getControl(mainOrgKey)) != null) {
            mainOrgEdit.addMainOrgChangeListener((MainOrgChangeListener)this);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit edit = (MulBasedataEdit)this.getView().getControl("reason");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit reasonEntry = (MulBasedataEdit)this.getView().getControl("mulreasonentry");
        reasonEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit printTplEntry = (BasedataEdit)this.getView().getControl("printtpl");
        printTplEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit receiveWayEntry = (BasedataEdit)this.getView().getControl("receiveway");
        receiveWayEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit econTplEntry = (BasedataEdit)this.getView().getControl("econtpl");
        econTplEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean isCurrPage = BaseDataHisHelper.isCurrPage((IFormView)this.getView());
        if (isCurrPage) {
            DynamicObject dataTpl = this.getModel().getDataEntity(true);
            Map issueTypeMap = this.incomeProofTplService.getIssueTypeMap(dataTpl);
            this.setIssueType("ispageissue", (Boolean)issueTypeMap.get("ispageissue"));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataTpl = this.getModel().getDataEntity(true);
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("customtpldesc"), Boolean.valueOf(dataTpl.getBoolean("isuploadtpl")));
        Map issueTypeMap = this.incomeProofTplService.getIssueTypeMap(dataTpl);
        viewHandle.setVisible(this.getView(), Collections.singletonList("econtpl"), issueTypeMap.getOrDefault("iselecissue", Boolean.FALSE));
        ((FieldsHandle)viewHandle).setMultiValue(this.getView(), issueTypeMap, Boolean.FALSE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("receivewaycfg"), (Boolean)issueTypeMap.get("ispageissue"));
        DynamicObjectCollection entryCol = dataTpl.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCol) {
            if (entry.getDynamicObject("printtpl") != null) continue;
            entry.set("printtpl", null);
        }
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("reason".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long orgId = dataEntity.getLong("org.id");
            if (orgId == 0L) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"IncomeProofTplPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                return;
            }
            event.addCustomQFilter(this.appliyReasonService.getQueryFilter(Collections.singletonList(orgId)));
            return;
        }
        if ("mulreasonentry".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection reasonCollection = dataEntity.getDynamicObjectCollection("reason");
            List reasonIdList = reasonCollection.stream().map(data -> data.getLong("fbasedataid.id")).collect(Collectors.toList());
            if (reasonIdList.isEmpty()) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5458\u5de5\u53ef\u9009\u8bc1\u660e\u7528\u9014\u3002", (String)"IncomeProofTplPlugin_2", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                return;
            }
            event.addCustomQFilter(new QFilter("id", "in", reasonIdList));
            return;
        }
        if ("printtpl".equals(key)) {
            DynamicObject dataTpl = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryCol = dataTpl.getDynamicObjectCollection("entryentity");
            List printIds = entryCol.stream().filter(entry -> SWCStringUtils.isNotEmpty((String)entry.getString("printtpl.id"))).map(entry -> entry.getString("printtpl.id")).collect(Collectors.toList());
            List enablePrintTplIds = this.incomeProofTplService.getEnablePrintTplIds();
            enablePrintTplIds.removeAll(printIds);
            event.addCustomQFilter(new QFilter("id", "in", (Object)enablePrintTplIds));
            return;
        }
        if ("receiveway".equals(key)) {
            DynamicObject dataTpl = this.getModel().getDataEntity(true);
            event.addCustomQFilter(new QFilter("id", "not in", (Object)this.incomeProofTplService.getReceiveWayIds(dataTpl)));
            return;
        }
        if ("econtpl".equals(key)) {
            event.addCustomQFilter(new QFilter("signtype", "=", (Object)"1"));
        }
    }

    public void afterChangeMainOrg(AfterChangeMainOrgEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection reasonCollection = dataEntity.getDynamicObjectCollection("reason");
        reasonCollection.removeIf(reason -> reason.getLong("fbasedataid.id") == 0L);
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setValueNotChanged(this.getView(), "reason", (Object)reasonCollection);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("ispageissue".equals(name) || "iselecissue".equals(name)) {
            changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.setIssueType(name, newValue);
        }
        if ("isuploadtpl".equals(name)) {
            changeData = e.getChangeSet()[0];
            Boolean isUpload = (Boolean)changeData.getNewValue();
            IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
            viewHandle.setVisible(this.getView(), Collections.singletonList("customtpldesc"), isUpload);
            if (!isUpload.booleanValue()) {
                viewHandle.setValueNotChanged(this.getView(), "customtpldesc", null);
            }
        }
        if ("reason".equals(name)) {
            DynamicObject dataTpl = this.getModel().getDataEntity(true);
            DynamicObjectCollection reasonCollection = dataTpl.getDynamicObjectCollection("reason");
            Set reasonIdSet = reasonCollection.stream().map(reason -> reason.getLong("fbasedataid.id")).collect(Collectors.toSet());
            DynamicObjectCollection entryCol = dataTpl.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                DynamicObjectCollection reasonMul = entry.getDynamicObjectCollection("mulreasonentry");
                reasonMul.removeIf(reason -> {
                    Long reasonId = reason.getLong("fbasedataid.id");
                    return !reasonIdSet.contains(reasonId);
                });
                entry.set("mulreasonentry", (Object)reasonMul);
            }
            this.getView().updateView("entryentity");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formOp;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (formOp = source.getOperateKey()) {
            case "save": {
                boolean cancelDataRight = SWCPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView());
                if (!cancelDataRight) break;
                args.setCancel(true);
                return;
            }
            case "enable": 
            case "audit": 
            case "unaudit": 
            case "disable": 
            case "auditconfirmchange": {
                OperateOption option = source.getOption();
                String ignoreValue = option.getVariableValue("ignoreFlag", "");
                if (SWCStringUtils.equals((String)"1", (String)ignoreValue)) {
                    return;
                }
                TplBaseOperation operation = this.incomeProofTplService.decorator(formOp);
                BaseResult baseResult = operation.beforeOperation(this.getModel().getDataEntity(true));
                if (baseResult.isSuccess()) break;
                args.setCancel(true);
                FormHandle handle = (FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                handle.dealOperationResult(this.getView(), baseResult, new ConfirmCallBackListener(formOp, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "enable": 
            case "audit": 
            case "unaudit": 
            case "disable": 
            case "auditconfirmchange": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreFlag", "1");
                this.getView().invokeOperation(key, option);
                break;
            }
        }
    }

    private void setIssueType(String key, Boolean isSelect) {
        FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        String value = "";
        if ("ispageissue".equals(key)) {
            value = "0";
            viewHandle.setVisible(this.getView(), Collections.singletonList("receivewaycfg"), isSelect);
            if (isSelect.booleanValue()) {
                DynamicObject receiveWay;
                if (this.incomeProofTplService.getReceiveWays(this.getModel().getDataEntity(true)).isEmpty() && (receiveWay = this.receiveWayService.getSiteEnableReceiveWay(IncomeProofCommon.RECEIVEWAY_SITE)) != null) {
                    HashMap<String, Long> fieldMap = new HashMap<String, Long>(16);
                    fieldMap.put("receiveway", receiveWay.getLong("id"));
                    this.getViewHandle(HandleTypeEnum.ENTRY_HANDLE).batchCreateNewEntryRow(this.getView(), "receivewayentry", Collections.singletonList(fieldMap));
                }
            } else {
                this.getViewHandle(HandleTypeEnum.ENTRY_HANDLE).deleteEntry(this.getModel(), "receivewayentry", null);
            }
        }
        if ("iselecissue".equals(key)) {
            value = "1";
            viewHandle.setVisible(this.getView(), Collections.singletonList("econtpl"), isSelect);
            if (!isSelect.booleanValue()) {
                DynamicObject dataTpl = this.getModel().getDataEntity(true);
                DynamicObjectCollection entryCol = dataTpl.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    Long econTplId = entry.getLong("econtpl.id");
                    if (econTplId.equals(0L)) continue;
                    entry.set("econtpl", null);
                }
                this.getView().updateView("entryentity");
            }
        }
        if (SWCStringUtils.isEmpty((String)value)) {
            return;
        }
        if (isSelect.booleanValue()) {
            viewHandle.addMulComboValue(this.getView(), "issuetype", value);
        } else {
            viewHandle.subMulComboValue(this.getView(), "issuetype", value);
        }
    }
}

