/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.RevenueFieldService;
import kd.swc.hcss.common.common.RevenueFieldCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.enums.IncomeValueSourceEnum;
import kd.swc.hcss.common.enums.RevenueFieldEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssBaseFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class RevenueFieldPlugin
extends AbstractHcssBaseFormPlugin
implements RevenueFieldCommon,
BeforeF7SelectListener {
    private RevenueFieldService revenueFieldService = (RevenueFieldService)DomainFactory.getInstance(RevenueFieldService.class);
    private static final Map<String, List<String>> CONTROL_MAP = ImmutableMap.builder().put((Object)IncomeValueSourceEnum.REVENUE_FIELD.getCode(), Collections.singletonList("currencyflex")).build();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit standardItem = (BasedataEdit)this.getView().getControl("standarditem");
        standardItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit valueExpShow = (TextEdit)this.getView().getControl("valueexpshow");
        valueExpShow.addClickListener((ClickListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("standarditem".equals(key)) {
            BaseResult result = this.getViewHandle(HandleTypeEnum.COUNTRY_HANDLE).getFilter(this.getCountryValueMap("hsbs_standarditem"));
            if (result.isSuccess()) {
                event.addCustomQFilter((QFilter)result.getData());
                QFilter filter = new QFilter("biztype", "like", (Object)"%,1,%");
                filter.or(new QFilter("biztype", "=", (Object)"1"));
                event.addCustomQFilter(filter);
            } else {
                this.getView().showTipNotification(result.getMessage());
                event.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("valueexpshow".equals(key)) {
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.COUNTRY_HANDLE);
            BaseResult baseResult = handle.getFilter(this.getCountryValueMap("hcss_revenuefield"));
            if (!baseResult.isSuccess()) {
                this.getView().showTipNotification(baseResult.getMessage());
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("filter", SerializationUtils.serializeToBase64((Object)baseResult.getData()));
            map.put("valueexpshow", dataEntity.getString("valueexpshow"));
            map.put("org.id", dataEntity.getLong("createorg.id"));
            handle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
            FormShowParameter parameter = new FormShowParameter();
            baseResult = handle.showForm(parameter, "hcss_valueexpconfirm", ShowType.Modal, new CloseCallBack((IFormPlugin)this, "hcss_valueexpconfirm"), map);
            this.getView().showForm((FormShowParameter)baseResult.getData());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if ("valuesource".equals(name)) {
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
            handle.showSecondConfirm(this.getView(), ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u76f8\u5173\u914d\u7f6e\u5b57\u6bb5\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5207\u6362\uff1f", (String)"RevenueFieldPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]), new ConfirmCallBackListener("valuesource", (IFormPlugin)this), oldValue.toString());
            return;
        }
        if ("areatype".equals(name)) {
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
            boolean isAreaType = "2".equals(newValue);
            handle.setVisible(this.getView(), Collections.singletonList("country"), Boolean.valueOf(isAreaType));
            handle.setMustInput(this.getView(), Collections.singletonList("country"), Boolean.valueOf(isAreaType));
            if (isAreaType) {
                handle.clearValue(this.getView(), Arrays.asList("standarditem", "valueexpshow", "valueexp"));
            } else {
                handle.clearValue(this.getView(), Collections.singletonList("country"));
            }
            return;
        }
        if ("country".equals(name)) {
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
            handle.clearValue(this.getView(), Arrays.asList("standarditem", "valueexpshow", "valueexp"));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean cancelDataRight;
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(formOp) && (cancelDataRight = SWCPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView()))) {
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "valuesource": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.valueSourceChanged();
                    break;
                }
                String customValue = messageBoxClosedEvent.getCustomVaule();
                this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE).setValueNotChanged(this.getView(), "valuesource", (Object)customValue);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("hcss_valueexpconfirm".equals(actionId) && (returnData = (Map)event.getReturnData()) != null && ((Boolean)returnData.get("isOk")).booleanValue()) {
            String valueExp = String.valueOf(returnData.get("valueexp"));
            String valueExpShow = String.valueOf(returnData.get("valueexpshow"));
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
            handle.setValueNotChanged(this.getView(), "valueexp", (Object)valueExp);
            handle.setValueNotChanged(this.getView(), "valueexpshow", (Object)valueExpShow);
        }
    }

    private Map<String, Object> getCountryValueMap(String entityId) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long orgId = dataEntity.getLong("createorg.id");
        String areaType = dataEntity.getString("areatype");
        Long countryId = dataEntity.getLong("country.id");
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("orgId", orgId);
        param.put("areaType", areaType);
        param.put("countryId", countryId);
        param.put("entityId", entityId);
        return param;
    }

    private void initData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String valueSource = dataEntity.getString("valuesource");
        List revenueFieldEnums = (List)this.revenueFieldService.getFieldMap().get(valueSource);
        String areaType = dataEntity.getString("areatype");
        boolean isAreaType = "2".equals(areaType);
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), Collections.singletonList("country"), Boolean.valueOf(isAreaType));
        handle.setMustInput(this.getView(), Collections.singletonList("country"), Boolean.valueOf(isAreaType));
        this.setVisibleHandle(valueSource, handle, revenueFieldEnums);
        this.setMustInputHandle(valueSource, handle, revenueFieldEnums);
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (BillOperationStatus.ADDNEW == billStatus) {
            this.setEnableDefaultHandle(handle, revenueFieldEnums);
        }
        if (BillOperationStatus.ADDNEW != billStatus && IncomeValueSourceEnum.STANDARD.getCode().equals(valueSource)) {
            handle.setEnable(this.getView(), Collections.singletonList("valuesource"), Boolean.FALSE);
        }
        if (IncomeValueSourceEnum.REVENUE_FIELD.getCode().equals(valueSource)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Boolean isCopy = (Boolean)parameter.getCustomParam("iscopy");
            Boolean isCheckEnable = BillOperationStatus.ADDNEW == billStatus && isCopy != null && isCopy != false;
            String valueExpShow = this.getValueExpShow(isCheckEnable);
            if (SWCStringUtils.isEmpty((String)valueExpShow)) {
                handle.setValueNotChanged(this.getView(), "valueexp", (Object)"");
            }
            handle.setValueNotChanged(this.getView(), "valueexpshow", (Object)valueExpShow);
        }
    }

    private void valueSourceChanged() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String valueSource = dataEntity.getString("valuesource");
        List revenueFieldEnums = (List)this.revenueFieldService.getFieldMap().get(valueSource);
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        this.clearValueHandle(valueSource, handle);
        this.setVisibleHandle(valueSource, handle, revenueFieldEnums);
        this.setMustInputHandle(valueSource, handle, revenueFieldEnums);
        this.setEnableDefaultHandle(handle, revenueFieldEnums);
    }

    private void clearValueHandle(String valueSource, IViewHandle handle) {
        ArrayList clearFields = new ArrayList(10);
        this.revenueFieldService.getFieldMap().forEach((field, list) -> {
            if (!field.equals(valueSource)) {
                clearFields.addAll(list.stream().map(RevenueFieldEnum::getCode).collect(Collectors.toList()));
            }
        });
        handle.clearValue(this.getView(), clearFields);
    }

    private void setVisibleHandle(String valueSource, IViewHandle handle, List<RevenueFieldEnum> revenueFieldEnums) {
        List showControls = revenueFieldEnums == null ? Collections.EMPTY_LIST : revenueFieldEnums.stream().map(RevenueFieldEnum::getCode).collect(Collectors.toList());
        ArrayList hideControls = new ArrayList(10);
        this.revenueFieldService.getFieldMap().forEach((field, list) -> {
            if (!field.equals(valueSource)) {
                hideControls.addAll(list.stream().map(RevenueFieldEnum::getCode).collect(Collectors.toList()));
            }
        });
        CONTROL_MAP.forEach((control, list) -> {
            if (control.equals(valueSource)) {
                showControls.addAll(list);
            }
            if (!control.equals(valueSource)) {
                hideControls.addAll(list);
            }
        });
        handle.setVisible(this.getView(), showControls, Boolean.TRUE);
        handle.setVisible(this.getView(), hideControls, Boolean.FALSE);
    }

    private void setMustInputHandle(String valueSource, IViewHandle handle, List<RevenueFieldEnum> revenueFieldEnums) {
        List mustInputControls = revenueFieldEnums == null ? Collections.EMPTY_LIST : revenueFieldEnums.stream().filter(RevenueFieldEnum::isMustInput).map(RevenueFieldEnum::getCode).collect(Collectors.toList());
        ArrayList notMustInputControls = new ArrayList(10);
        this.revenueFieldService.getFieldMap().forEach((field, list) -> {
            if (!field.equals(valueSource)) {
                notMustInputControls.addAll(list.stream().filter(RevenueFieldEnum::isMustInput).map(RevenueFieldEnum::getCode).collect(Collectors.toList()));
            }
        });
        handle.setMustInput(this.getView(), mustInputControls, Boolean.TRUE);
        handle.setVisible(this.getView(), notMustInputControls, Boolean.FALSE);
    }

    private void setEnableDefaultHandle(IViewHandle handle, List<RevenueFieldEnum> revenueFieldEnums) {
        List<RevenueFieldEnum> defaultControls = revenueFieldEnums == null ? Collections.EMPTY_LIST : revenueFieldEnums.stream().filter(field -> field.getDefaultValue() != null).collect(Collectors.toList());
        defaultControls.forEach(fieldEnum -> handle.setValueNotChanged(this.getView(), fieldEnum.getCode(), fieldEnum.getDefaultValue()));
        handle.clearDisabledBaseDataValue(this.getView(), Boolean.FALSE);
    }

    private String getValueExpShow(Boolean isCheckEnable) {
        String valueExp = this.getModel().getDataEntity().getString("valueexp");
        return this.revenueFieldService.getValueExpShow(valueExp, isCheckEnable);
    }
}

