/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.helper.FilterHelper;
import kd.swc.hcss.business.helper.FormulaHelper;
import kd.swc.hcss.business.service.income.RevenueFieldService;
import kd.swc.hcss.common.common.RevenueFieldCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.enums.IncomeValueSourceEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssDyFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ValueExpPlugin
extends AbstractHcssDyFormPlugin
implements RevenueFieldCommon,
TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_TREE_MAP = "treeMap";
    private RevenueFieldService revenueFieldService = (RevenueFieldService)DomainFactory.getInstance(RevenueFieldService.class);

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(FormulaHelper.OPERATIONCHARACTER.keySet().toArray(new String[0]));
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        this.buildFieldNodes(treeNodes);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        BaseResult baseResult = this.getViewHandle(HandleTypeEnum.TREE_VIEW_HANDLE).getTreeView(treeNodes);
        if (baseResult.isSuccess()) {
            List nodeList = (List)baseResult.getData();
            treeView.addNodes(nodeList);
        }
        String valueExp = (String)this.getView().getFormShowParameter().getCustomParam("valueexpshow");
        this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE).setValueNotChanged(this.getView(), "valueexp", (Object)valueExp);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String treeNodeString = this.getView().getPageCache().get(KEY_TREE_MAP);
        if (SWCStringUtils.isEmpty((String)treeNodeString)) {
            return;
        }
        BiMap idNameMap = (BiMap)SerializationUtils.deSerializeFromBase64((String)treeNodeString);
        String name = "[" + (String)idNameMap.get((Object)nodeId) + "]";
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)KEY_TREEVIEW, (String)"valueexp", (String)name);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String character = (String)FormulaHelper.OPERATIONCHARACTER.get(key);
        if (SWCStringUtils.isNotEmpty((String)character)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)"valueexp", (String)character);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateName;
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && this.validateFormula(operateName = operate.getOperateName().getLocaleValue())) {
            args.setCancel(true);
        }
    }

    private Map<String, String> getData() {
        String filterString = (String)this.getView().getFormShowParameter().getCustomParam("filter");
        if (SWCStringUtils.isEmpty((String)filterString)) {
            return Collections.EMPTY_MAP;
        }
        QFilter filter = (QFilter)SerializationUtils.deSerializeFromBase64((String)filterString);
        filter.and("valuesource", "=", (Object)IncomeValueSourceEnum.STANDARD.getCode());
        return this.revenueFieldService.queryRevenueFieldNameMap(new QFilter[]{filter, FilterHelper.getEnableAuditFilter()});
    }

    private void buildFieldNodes(List<TreeNode> treeNodes) {
        Map<String, String> fieldDataMap = this.getData();
        HashBiMap idNameMap = HashBiMap.create(fieldDataMap);
        fieldDataMap.forEach((arg_0, arg_1) -> ValueExpPlugin.lambda$buildFieldNodes$0(treeNodes, (BiMap)idNameMap, arg_0, arg_1));
        this.getView().getPageCache().put(KEY_TREE_MAP, SerializationUtils.serializeToBase64((Object)idNameMap));
    }

    private boolean validateFormula(String operateName) {
        HashBiMap idNameMap;
        HashBiMap nameIdMap;
        String valueExp = this.getModel().getDataEntity().getString("valueexp");
        String treeNodeString = this.getView().getPageCache().get(KEY_TREE_MAP);
        if (SWCStringUtils.isEmpty((String)treeNodeString)) {
            nameIdMap = HashBiMap.create();
            idNameMap = HashBiMap.create();
        } else {
            idNameMap = (BiMap)SerializationUtils.deSerializeFromBase64((String)treeNodeString);
            nameIdMap = idNameMap.inverse();
        }
        Tuple tuple = this.revenueFieldService.analysis(valueExp, (BiMap)nameIdMap);
        if (!((List)tuple.item2).isEmpty()) {
            this.showErrorForm(operateName, (List)tuple.item2);
            return false;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.setDataChanged(false);
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
        returnData.put("isOk", Boolean.TRUE);
        returnData.put("valueexp", FormulaHelper.transformExpression((List)((List)tuple.item1), (Map)nameIdMap));
        returnData.put("valueexpshow", FormulaHelper.transformExpression((List)((List)tuple.item1), (Map)idNameMap));
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
        return true;
    }

    private void showErrorForm(String operateName, List<String> failList) {
        this.getViewHandle(HandleTypeEnum.FORM_HANDLE).showOperationResultForm(this.getView(), ErrorLevel.Error, operateName, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ValueExpPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]), failList);
    }

    private static /* synthetic */ void lambda$buildFieldNodes$0(List treeNodes, BiMap idNameMap, String id, String name) {
        TreeNode node = new TreeNode("", id, name);
        treeNodes.add(node);
        idNameMap.put((Object)id, (Object)name);
    }
}

