/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income.deal;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssDyFormPlugin;

public class CheckApprovePlugin
extends AbstractHcssDyFormPlugin
implements IncomeProofCommon {
    private static final String SAVE = "save";
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SAVE) && !this.checkPerm()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SAVE)) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.TRUE);
            returnData.put("exratedate", this.getModel().getDataEntity().getDate("exratedate"));
            this.getView().returnDataToParent((Object)returnData);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        if (SAVE.equals(key) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isSecondConfirm", "true");
            this.getView().invokeOperation(SAVE, option);
        }
    }

    private boolean checkPerm() {
        OperationResult hasPerm = "hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway")) ? this.incomeProofBillService.hasPerm("40A+670S4LST", "31NAW9YTHWZ9", ResManager.loadKDString((String)"\u6838\u5b9a\u6536\u5165", (String)"CheckApprovePlugin_4", (String)"swc-hcss-formplugin", (Object[])new Object[0])) : this.incomeProofBillService.hasPerm("31NAW9YTHWZ9", ResManager.loadKDString((String)"\u6838\u5b9a\u6536\u5165", (String)"CheckApprovePlugin_4", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
        if (!hasPerm.isSuccess()) {
            this.getView().showOperationResult(hasPerm);
            return false;
        }
        Long billId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if (billId == null) {
            return true;
        }
        List havePermBillIds = "hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway")) ? this.incomeProofBillService.getHavePermBillIds("40A+670S4LST", Collections.singletonList(billId), "31NAW9YTHWZ9") : this.incomeProofBillService.getHavePermBillIds(Collections.singletonList(billId), "31NAW9YTHWZ9");
        if (havePermBillIds.isEmpty()) {
            IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
            viewHandle.showSecondConfirm(this.getView(), ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"CheckApprovePlugin_3", (String)"swc-hcss-formplugin", (Object[])new Object[0]), null, "");
            return false;
        }
        return true;
    }
}

