/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income.deal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.entity.ExchangeRateDetailDTO;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssDyFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ExchangeRateDetailPlugin
extends AbstractHcssDyFormPlugin
implements IncomeProofCommon {
    private static final String EXRATETABLE = "exratetable";
    private static final String ORIGINALCURRENCY = "originalcurrency";
    private static final String TARGETCURRENCY = "targetcurrency";
    private static final String QUOTETYPE = "quotetype";
    private static final String EXCHANGERATE = "exchangerate";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
    }

    private void initData() {
        String rateTable = (String)this.getView().getFormShowParameter().getCustomParam("ratetable");
        if (SWCStringUtils.isEmpty((String)rateTable)) {
            return;
        }
        Map fieldRateDetailMap = (Map)JSON.parseObject((String)rateTable, (TypeReference)new TypeReference<Map<Long, Map<Long, ExchangeRateDetailDTO>>>(){}, (Feature[])new Feature[0]);
        ArrayList fieldMapList = new ArrayList(fieldRateDetailMap.size());
        fieldRateDetailMap.forEach((revenueFieldId, rateDetailMap) -> rateDetailMap.forEach((originalCurrencyId, rateDetail) -> {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            fieldMap.put("revenuefield", revenueFieldId);
            fieldMap.put("exratedate", rateDetail.getExrateDate());
            fieldMap.put(EXRATETABLE, rateDetail.getExrateTableId());
            fieldMap.put(ORIGINALCURRENCY, rateDetail.getOriginalCurrencyId());
            fieldMap.put(TARGETCURRENCY, rateDetail.getTargetCurrencyId());
            fieldMap.put(EXCHANGERATE, rateDetail.getExchangeRate());
            fieldMap.put(QUOTETYPE, rateDetail.getQuoteType());
            fieldMapList.add(fieldMap);
        }));
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.ENTRY_HANDLE);
        viewHandle.batchCreateNewEntryRow(this.getView(), "entryentity", fieldMapList);
        this.getModel().setDataChanged(false);
    }
}

