/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income.deal;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.formplugin.web.AbstractHcssFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IncomeDealCardPlugin
extends GridCardPlugin
implements AbstractHcssFormPlugin,
IncomeProofCommon {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);
    private static final String APPROVEING = "approveing";
    private static final String ISSUED = "issued";
    private static final String CLAIMED = "claimed";
    private static final String SIGNFAIL = "signfail";
    private static final String CLAIMEDBTN = "claimedbtn";
    private static final String FLEXNOTPERM = "flexnotperm";
    private static final String FLEXCONTENT = "flexcontent";
    private static final String NUMMAP = "numMap";
    private static final Map<String, List<String>> STATUS_MAP = ImmutableMap.builder().put((Object)"approveing", Arrays.asList("A", "B")).put((Object)"issued", Collections.singletonList("I")).put((Object)"signfail", Collections.singletonList("F")).build();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{APPROVEING, ISSUED, SIGNFAIL});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        if ("refresh".equals(formOp)) {
            this.getView().updateView();
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        String numMapString = this.getView().getPageCache().get(NUMMAP);
        if (SWCStringUtils.isEmpty((String)numMapString)) {
            return;
        }
        Map numMap = (Map)JSON.parseObject((String)numMapString, Map.class);
        Integer integer = (Integer)numMap.get(key);
        if (integer == null || 0 == integer) {
            return;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        map.put("dealstatus", STATUS_MAP.get(key));
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
        ListShowParameter parameter = new ListShowParameter();
        handle.showForm((FormShowParameter)parameter, "hcss_incomeproofhandle", ShowType.MainNewTabPage, null, map);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initData() {
        OperationResult result = this.incomeProofBillService.hasViewPerm();
        boolean success = result.isSuccess();
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), Collections.singletonList(FLEXNOTPERM), Boolean.valueOf(!success));
        handle.setVisible(this.getView(), Arrays.asList(FLEXCONTENT, "refresh"), Boolean.valueOf(success));
        if (!success) {
            return;
        }
        IFormView view = this.getView();
        HashMap map = new HashMap(16);
        STATUS_MAP.forEach((key, value) -> {
            int statusNum = this.incomeProofBillService.getBillStatusNum(value);
            map.put(key, statusNum);
            handle.setLabValue(view, key, String.valueOf(statusNum));
            if (CLAIMED.equals(key)) {
                handle.setVisible(view, Collections.singletonList(CLAIMEDBTN), Boolean.valueOf(statusNum > 0));
            }
        });
        this.getView().getPageCache().put(NUMMAP, JSON.toJSONString(map));
    }
}

