/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income.deal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.action.FieldsHandle;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.model.income.IncomeDealCalResultDTO;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssBaseFormPlugin;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IncomeProofBillDealPlugin
extends AbstractHcssBaseFormPlugin
implements IncomeProofCommon {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initData();
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"person.name");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        String formOp = source.getOperateKey();
        Long id = this.getModel().getDataEntity().getLong("id");
        DynamicObject dataDeal = this.getModel().getDataEntity();
        if (OP_LIST.contains(formOp)) {
            String ignoreValue;
            if (id != 0L) {
                BillModel model = (BillModel)this.getView().getService(IDataModel.class);
                model.load((Object)id);
            }
            if (SWCStringUtils.equals((String)"1", (String)(ignoreValue = option.getVariableValue("ignoreFlag", "")))) {
                return;
            }
            BaseOperation decorator = this.incomeProofBillService.decorator(formOp);
            BaseResult baseResult = decorator.beforeOperation(dataDeal, option, (AbstractFormPlugin)this);
            if (!baseResult.isSuccess()) {
                args.setCancel(true);
                FormHandle handle = (FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                handle.dealOperationResult(this.getView(), baseResult, new ConfirmCallBackListener(formOp, (IFormPlugin)this));
                this.getView().invokeOperation("refresh");
                return;
            }
            if ("checkapprove".equals(formOp)) {
                this.checkApprove(args, dataDeal, option, id);
            }
            if ("viewflowchart".equals(formOp)) {
                JSONObject json = (JSONObject)baseResult.getData();
                args.setCancel(true);
                WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)this.getView().getPageId(), (String)json.getString("datasource"), (Object)json.getLong("id"));
            }
            return;
        }
        if ("saveincomeinfo".equals(formOp)) {
            BaseOperation decorator = this.incomeProofBillService.decorator(formOp);
            BaseResult baseResult = decorator.beforeOperation(this.getModel().getDataEntity());
            if (!baseResult.isSuccess()) {
                args.setCancel(true);
                FormHandle handle = (FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                handle.dealOperationResult(this.getView(), baseResult, new ConfirmCallBackListener(formOp, (IFormPlugin)this));
            }
            return;
        }
        if ("modify".equals(formOp)) {
            BaseResult baseResult = this.incomeProofBillService.beforeSscOperation(new DynamicObject[]{this.getModel().getDataEntity()});
            if (baseResult.isSuccess()) {
                this.setIncomeInfoEnableEdit(Boolean.TRUE);
                FieldsHandle handle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
                handle.setEnable(this.getView(), Collections.singletonList("lawentity"), Boolean.TRUE);
                handle.setVisible(this.getView(), Collections.singletonList("save"), Boolean.TRUE);
                handle.setVisible(this.getView(), Arrays.asList("modify", "firmcommit"), Boolean.FALSE);
            } else {
                this.getView().showErrorNotification(baseResult.getMessage());
            }
            return;
        }
        if ("ratetable".equals(formOp)) {
            String rateTable = this.getView().getPageCache().get("ratetable");
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("ratetable", rateTable);
            this.getViewHandle(HandleTypeEnum.FORM_HANDLE).showForm(parameter, "hcss_ratedetail", ShowType.Modal, new CloseCallBack((IFormPlugin)this, "hcss_ratedetail"), map);
            this.getView().showForm(parameter);
        }
    }

    private void checkApprove(BeforeDoOperationEventArgs args, DynamicObject dataDeal, OperateOption option, Long id) {
        DynamicObjectCollection revenueFieldCol = this.incomeProofBillService.getRevenueFieldCol(dataDeal.getString("printtpl.id"));
        boolean isNeedExrateDate = revenueFieldCol.stream().anyMatch(revenueField -> "1".equals(revenueField.getString("exratedate")));
        Date date = null;
        String exrateDate = option.getVariableValue("exratedate", "");
        if (SWCStringUtils.isNotEmpty((String)exrateDate)) {
            date = (Date)JSON.parseObject((String)exrateDate, Date.class);
        }
        if (isNeedExrateDate && date == null) {
            IViewHandle handle = this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Long> customParam = new HashMap<String, Long>(16);
            if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway"))) {
                customParam.putAll(this.getView().getFormShowParameter().getCustomParams());
            }
            customParam.put("id", id);
            handle.showForm(parameter, "hcss_checkapprove", ShowType.Modal, new CloseCallBack((IFormPlugin)this, "hcss_checkapprove"), customParam);
            this.getView().showForm(parameter);
            args.setCancel(true);
            return;
        }
        this.calIncomeInfo(dataDeal, revenueFieldCol, date);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_REFRESH_LIST.contains(operateKey) && !args.getOperationResult().getSuccessPkIds().isEmpty()) {
            BaseResult baseResult = this.incomeProofBillService.decorator(operateKey).afterOperation(args);
            if (baseResult.isSuccess()) {
                if ("issued".equals(operateKey)) {
                    Map printBillMap = (Map)baseResult.getData();
                    String taskId = this.incomeProofBillService.getPreviewIncomeProofBillPdfTaskId();
                    List attachList = this.incomeProofBillService.getPreviewIncomeProofBillPdfAttachList(taskId, printBillMap, this.getView().getPageId());
                    ((FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE)).printPreview(this.getView(), taskId, attachList);
                }
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showErrorNotification(baseResult.getMessage());
            }
        }
        this.setAttachment(this.getModel().getDataEntity());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("hcss_checkapprove".equals(actionId)) {
            Map returnData2 = (Map)event.getReturnData();
            if (returnData2 != null && ((Boolean)returnData2.get("isOk")).booleanValue()) {
                Date exrateDate = (Date)returnData2.get("exratedate");
                OperateOption option = OperateOption.create();
                option.setVariableValue("exratedate", JSON.toJSONString((Object)exrateDate));
                this.getView().invokeOperation("checkapprove", option);
            }
            return;
        }
        if ("hcss_dealresign".equals(actionId) && (returnData = (Map)event.getReturnData()) != null && ((Boolean)returnData.get("isOk")).booleanValue()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("lawentity", JSON.toJSONString(returnData.get("lawentity")));
            option.setVariableValue("ignoreFlag", "1");
            this.getView().invokeOperation("resign", option);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("firmcommit".equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreFlag", "1");
            this.getView().invokeOperation(callBackId, option);
        }
    }

    private void initData() {
        DynamicObject dataDeal = this.getModel().getDataEntity(true);
        this.setVisibleBtn(dataDeal);
        this.setPersonInfo(dataDeal);
        this.setFieldInfo(dataDeal);
        this.autoCalIncomeInfo(dataDeal);
        this.setAttachment(dataDeal);
        this.getModel().setDataChanged(false);
    }

    private void autoCalIncomeInfo(DynamicObject dataDeal) {
        boolean isCal;
        boolean isUpload = dataDeal.getBoolean("isuploadtpl");
        if (isUpload) {
            return;
        }
        String billStatus = dataDeal.getString("billstatus");
        String dealStatus = dataDeal.getString("dealstatus");
        boolean bl = isCal = "C".equals(billStatus) && SWCStringUtils.isEmpty((String)dealStatus) || "A".equals(dealStatus);
        if (!isCal) {
            return;
        }
        DynamicObjectCollection revenueFieldCol = this.incomeProofBillService.getRevenueFieldCol(dataDeal.getString("printtpl.id"));
        this.calIncomeInfo(dataDeal, revenueFieldCol, null);
    }

    private void calIncomeInfo(DynamicObject dataDeal, DynamicObjectCollection revenueFieldCol, Date exrateDate) {
        IncomeDealCalResultDTO resultDTO = this.incomeProofBillService.calIncomeInfo(dataDeal, revenueFieldCol, exrateDate);
        if (resultDTO == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            return;
        }
        Map revenueFieldRateMap = resultDTO.getRevenueFieldRateMap();
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("incomeinfo"), Boolean.TRUE);
        this.setIncomeInfoEnableEdit(Boolean.TRUE);
        this.getView().getPageCache().put("ratetable", JSON.toJSONString((Object)revenueFieldRateMap));
        viewHandle.setVisible(this.getView(), Collections.singletonList("ratetableflex"), Boolean.valueOf(!revenueFieldRateMap.isEmpty()));
        this.createIncomeEntry(resultDTO.getResultMap());
        Map errorMap = resultDTO.getErrorMap();
        if (!errorMap.isEmpty()) {
            HashSet errorSet = new HashSet(16);
            errorMap.forEach((id, errors) -> errorSet.addAll(errors));
            this.getViewHandle(HandleTypeEnum.FORM_HANDLE).showOperationResultForm(this.getView(), ErrorLevel.Warning, ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"CheckApprovePlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6838\u5b9a\u6536\u5165\u7ed3\u679c", (String)"CheckApprovePlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]), new ArrayList(errorSet));
        }
    }

    private void createIncomeEntry(Map<Long, List<String>> resultMap) {
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.ENTRY_HANDLE);
        viewHandle.deleteEntry(this.getModel(), "entryentity", null);
        ArrayList fieldMapList = new ArrayList(resultMap.size());
        resultMap.forEach((revenueFieldId, resultList) -> {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            String calValue = resultList == null ? "" : String.join((CharSequence)",", resultList);
            fieldMap.put("revenuefield", revenueFieldId);
            fieldMap.put("calvalue", calValue);
            fieldMap.put("checkvalue", calValue);
            fieldMap.put("entdescription", "");
            fieldMapList.add(fieldMap);
        });
        viewHandle.batchCreateNewEntryRow(this.getView(), "entryentity", fieldMapList);
    }

    private void setFieldInfo(DynamicObject dataDeal) {
        MutableGraph fieldControlGraph = this.incomeProofBillService.getDealFieldControlGraph();
        LinkedHashMap resultMap = new LinkedHashMap(16);
        IncomeBillControlDTO changeField = new IncomeBillControlDTO("applyreason");
        this.incomeProofBillService.fieldInitData(changeField, dataDeal, fieldControlGraph, resultMap);
        changeField = new IncomeBillControlDTO("lawentity");
        this.incomeProofBillService.fieldInitData(changeField, dataDeal, fieldControlGraph, resultMap);
        ArrayList<IncomeBillControlDTO> controlList = new ArrayList<IncomeBillControlDTO>(resultMap.values());
        this.setFieldValue(controlList);
        String dealStatus = dataDeal.getString("dealstatus");
        String issueType = dataDeal.getString("issuetype");
        ArrayList<String> hideKey = new ArrayList<String>(10);
        ArrayList<String> showKey = new ArrayList<String>(10);
        if ("A".equals(dealStatus) || dataDeal.getBoolean("isuploadtpl")) {
            hideKey.add("incomeinfo");
        } else {
            showKey.add("incomeinfo");
            this.setIncomeInfoEnableEdit(Boolean.FALSE);
        }
        if (!dataDeal.getBoolean("ischeck") && dataDeal.getDynamicObjectCollection("entryentity").isEmpty()) {
            hideKey.add("incomeinfo");
            showKey.remove("incomeinfo");
        }
        hideKey.add("ratetableflex");
        if (!"1".equals(issueType) || !"K".equals(dealStatus)) {
            hideKey.add("attachmentpanel");
        } else {
            showKey.add("attachmentpanel");
        }
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), showKey, Boolean.TRUE);
        handle.setVisible(this.getView(), hideKey, Boolean.FALSE);
    }

    private void setFieldValue(List<IncomeBillControlDTO> controlList) {
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        ArrayList<String> enable = new ArrayList<String>(10);
        ArrayList<String> disEnable = new ArrayList<String>(10);
        ArrayList<String> show = new ArrayList<String>(10);
        ArrayList<String> hide = new ArrayList<String>(10);
        ArrayList<String> must = new ArrayList<String>(10);
        ArrayList<String> notMust = new ArrayList<String>(10);
        for (IncomeBillControlDTO controlDTO : controlList) {
            String fieldKey = controlDTO.getFieldKey();
            Boolean isEnable = controlDTO.getEnable();
            Boolean isVisible = controlDTO.getVisible();
            Boolean isMust = controlDTO.getMust();
            this.setControlList(isEnable, enable, disEnable, fieldKey);
            this.setControlList(isVisible, show, hide, fieldKey);
            this.setControlList(isMust, must, notMust, fieldKey);
        }
        handle.setEnable(this.getView(), enable, Boolean.TRUE);
        handle.setEnable(this.getView(), disEnable, Boolean.FALSE);
        handle.setVisible(this.getView(), show, Boolean.TRUE);
        handle.setVisible(this.getView(), hide, Boolean.FALSE);
        handle.setMustInput(this.getView(), must, Boolean.TRUE);
        handle.setMustInput(this.getView(), notMust, Boolean.FALSE);
    }

    private void setControlList(Boolean isCan, List<String> can, List<String> disCan, String fieldKey) {
        if (isCan == null) {
            return;
        }
        if (isCan.booleanValue()) {
            can.add(fieldKey);
        } else {
            disCan.add(fieldKey);
        }
    }

    private void setPersonInfo(DynamicObject dataDeal) {
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setValueNotChanged(this.getView(), "headsculpture", (Object)dataDeal.getString("person.headsculpture"));
        DynamicObject dataBill = this.getModel().getDataEntity();
        handle.setVisible(this.getView(), Arrays.asList("vectorposition", "position"), Boolean.valueOf(dataBill.getDynamicObject("position") != null));
        handle.setVisible(this.getView(), Arrays.asList("vectorapadminorg", "adminorg"), Boolean.valueOf(dataBill.getDynamicObject("adminorg") != null));
        handle.setVisible(this.getView(), Arrays.asList("vectorapcompany", "company"), Boolean.valueOf(dataBill.getDynamicObject("company") != null));
        handle.setVisible(this.getView(), Arrays.asList("vectorapphone", "phone"), Boolean.valueOf(SWCStringUtils.isNotEmpty((String)dataBill.getString("percontact.phone"))));
    }

    private void setVisibleBtn(DynamicObject dataDeal) {
        String dealStatus = dataDeal.getString("dealstatus");
        String isUpload = dataDeal.getString("isuploadtpl");
        String issueType = dataDeal.getString("issuetype");
        String[] btnArray = new String[]{dealStatus, isUpload, issueType};
        Map showHideButtons = this.incomeProofBillService.showHideButtons(btnArray);
        List showButtons = (List)showHideButtons.get("showButtons");
        List hideButtons = (List)showHideButtons.get("hideButtons");
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), hideButtons, Boolean.FALSE);
        handle.setVisible(this.getView(), showButtons, Boolean.TRUE);
    }

    private void setAttachment(DynamicObject billData) {
        String name = this.incomeProofBillService.getBillNameByDataSource(billData.getString("datasource"));
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("customtpl");
        attachment.bindData(this.incomeProofBillService.getAttachmentData(name, Long.valueOf(billData.getLong("id"))));
    }

    private void setIncomeInfoEnableEdit(Boolean isEdit) {
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway")) && "true".equals(this.getView().getFormShowParameter().getCustomParam("ifPending"))) {
            isEdit = false;
        }
        FieldsHandle handle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), Collections.singletonList("checkapprove"), isEdit);
        List<String> fields = Arrays.asList("checkvalue", "entdescription");
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<Integer, List<String>> rowFieldMap = new HashMap<Integer, List<String>>(entryCol.size());
        for (int index = 0; index < entryCol.size(); ++index) {
            rowFieldMap.put(index, fields);
        }
        handle.setEntryEnable(this.getView(), rowFieldMap, isEdit);
    }
}

