/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.formplugin.web.income.mobile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.swc.hcss.business.handle.action.FieldsHandle;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.model.income.IncomeBillIssueTypeDTO;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.formplugin.web.AbstractHcssDyMobileFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IncomeProofDetailPlugin
extends AbstractHcssDyMobileFormPlugin
implements IncomeProofCommon,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(IncomeProofDetailPlugin.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);
    private static final Map<String, List<String>> BUTTON_MAP = ImmutableMap.builder().put((Object)"A", Arrays.asList("submit", "delete", "save")).put((Object)"G", Arrays.asList("submit", "abandon", "save")).put((Object)"D", Collections.singletonList("unsubmit")).put((Object)"B", Collections.singletonList("unsubmit")).put((Object)"", Collections.singletonList("attachmentpanelhandle")).build();
    private static final String OPEN = "openflex";
    private static final String CLOSE = "closeflex";
    private static final String FLEXDESC = "flexdesc";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW != status) {
            return;
        }
        Long personId = this.incomeProofBillService.getCurPersonInfo().getOrDefault("person", 0L);
        Long orgId = this.incomeProofBillService.getPersonFileOrgId(personId);
        DynamicObject[] tplArray = this.incomeProofTplService.getAuditAndEnableDataArrayByOrg(orgId);
        if (tplArray == null || tplArray.length != 1) {
            log.info("tpl size is not one,orgId is {}", (Object)orgId);
            args.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"IncomeProofDetailPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        formShowParameter.setCustomParam("person", (Object)personId);
        formShowParameter.setCustomParam("incometpl", (Object)tplArray[0].getLong("sourcevid"));
        formShowParameter.setCustomParam("org", (Object)orgId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("applyreason");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit print = (BasedataEdit)this.getView().getControl("printtpl");
        print.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit receiveWay = (BasedataEdit)this.getView().getControl("receiveway");
        receiveWay.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"labelpage", "labelelec"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        FieldsHandle viewHandle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("person"));
        Long orgId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("org"));
        Long incomeTplId = HRJSONUtils.getLongValOfCustomParam((Object)parameter.getCustomParam("incometpl"));
        Map personInfoMap = this.incomeProofBillService.getPersonInfoMap(personId);
        viewHandle.setMultiValue(this.getView(), personInfoMap, Boolean.FALSE);
        viewHandle.setValueNotChanged(this.getView(), "incometpl", (Object)incomeTplId);
        viewHandle.setValueNotChanged(this.getView(), "org", (Object)orgId);
        this.isEdit(Boolean.TRUE);
        viewHandle.setVisible(this.getView(), Arrays.asList("vectorprinttpl", "flextips"), Boolean.FALSE);
        DynamicObject incomeTpl = this.getModel().getDataEntity().getDynamicObject("incometpl");
        if (incomeTpl == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"IncomeProofDetailPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!incomeTpl.getBoolean("isuploadtpl")) {
            viewHandle.setVisible(this.getView(), Arrays.asList("isuploadtpl", "attachmentpanel"), Boolean.FALSE);
        } else {
            viewHandle.setVisible(this.getView(), Collections.singletonList("attachmentpanel"), Boolean.FALSE);
        }
        viewHandle.setVisible(this.getView(), Arrays.asList("issuetypeflex", "mailinginfo", "receiveway", "receivetips", "issuenum"), Boolean.FALSE);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initData();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        DynamicObject billData = this.getModel().getDataEntity();
        if ("applyreason".equals(key)) {
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            Set reasonIdSet = incomeTpl.getDynamicObjectCollection("reason").stream().map(data -> data.getLong("fbasedataid.id")).collect(Collectors.toSet());
            event.addCustomQFilter(new QFilter("id", "in", reasonIdSet));
            return;
        }
        if ("printtpl".equals(key)) {
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            Long reasonId = billData.getLong("applyreason.id");
            if (reasonId.equals(0L)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc1\u660e\u7528\u9014\u3002", (String)"IncomeProofDetailPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            HashSet printIdSet = new HashSet(16);
            incomeTpl.getDynamicObjectCollection("entryentity").forEach(entry -> {
                DynamicObjectCollection reasonMul = entry.getDynamicObjectCollection("mulreasonentry");
                for (DynamicObject reason : reasonMul) {
                    if (!reasonId.equals(reason.getLong("fbasedataid.id"))) continue;
                    printIdSet.add(entry.getString("printtpl.id"));
                    break;
                }
            });
            event.addCustomQFilter(new QFilter("id", "in", printIdSet));
            return;
        }
        if ("receiveway".equals(key)) {
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            event.addCustomQFilter(new QFilter("id", "in", (Object)this.incomeProofTplService.getReceiveWayIds(incomeTpl)));
        }
    }

    public void click(EventObject event) {
        Control source = (Control)event.getSource();
        String key = source.getKey();
        if ("labelpage".equals(key)) {
            this.setIssueType("0");
            return;
        }
        if ("labelelec".equals(key)) {
            this.setIssueType("1");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        String formOp = source.getOperateKey();
        if (OPEN.equals(formOp)) {
            this.setFlexOpenOrClose(Boolean.TRUE);
            return;
        }
        if (CLOSE.equals(formOp)) {
            this.setFlexOpenOrClose(Boolean.FALSE);
            return;
        }
        if ("submit".equals(formOp) || "save".equals(formOp)) {
            DynamicObject billBaseData = this.getModel().getDataEntity();
            BaseResult baseResult = this.incomeProofBillService.decorator(formOp).beforeOperation(billBaseData, option, (AbstractFormPlugin)this);
            if (!baseResult.isSuccess()) {
                args.setCancel(true);
                FormHandle handle = (FormHandle)this.getViewHandle(HandleTypeEnum.FORM_HANDLE);
                handle.dealOperationResult(this.getView(), baseResult, new ConfirmCallBackListener(formOp, (IFormPlugin)this));
            }
            return;
        }
        if ("previewprinttpl".equals(formOp)) {
            DynamicObject billBaseData = this.getModel().getDataEntity();
            String printTplId = billBaseData.getString("printtpl.id");
            if (SWCStringUtils.isEmpty((String)printTplId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                return;
            }
            String printTplName = billBaseData.getString("printtpl.name");
            this.getView().previewAttachment(this.incomeProofBillService.getPreviewPrintTpl(printTplId, printTplName));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            result = args.getOperationResult();
            if (result.isSuccess()) {
                Long billId = (Long)result.getSuccessPkIds().get(0);
                this.setFlex(Boolean.FALSE);
                this.openSubmitSuccessPage(billId);
                BillModel model = (BillModel)this.getView().getService(IDataModel.class);
                model.load((Object)billId);
            } else {
                this.incomeProofBillService.recycleIncomeProofBillNumber(this.getModel().getDataEntity().getString("billno"));
            }
        }
        if (("unsubmitmob".equals(operateKey) || "abandonmob".equals(operateKey)) && (result = args.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        DynamicObject billBaseData = this.getModel().getDataEntity();
        this.setAttachment(billBaseData.getLong("id"));
        this.setAttachmentHandle(billBaseData.getLong("id"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        DynamicObject billData = this.getModel().getDataEntity();
        if ("applyreason".equals(name) || "printtpl".equals(name) || "isuploadtpl".equals(name) || "issuetype".equals(name) || "econtpl".equals(name) || "receiveway".equals(name)) {
            MutableGraph fieldControlGraph = this.incomeProofBillService.getFieldControlGraph();
            IncomeBillControlDTO changeField = new IncomeBillControlDTO(name);
            changeField.setValue(newValue);
            LinkedHashMap resultMap = new LinkedHashMap(16);
            this.incomeProofBillService.fieldPropertyChanged(changeField, billData, fieldControlGraph, resultMap);
            ArrayList<IncomeBillControlDTO> controlList = new ArrayList<IncomeBillControlDTO>(resultMap.values());
            this.setFieldValue(controlList, true);
        }
    }

    private void setFieldValue(List<IncomeBillControlDTO> controlList, boolean isNeedSetValue) {
        IViewHandle handle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        ArrayList<String> enable = new ArrayList<String>(10);
        ArrayList<String> disEnable = new ArrayList<String>(10);
        ArrayList<String> show = new ArrayList<String>(10);
        ArrayList<String> hide = new ArrayList<String>(10);
        ArrayList<String> must = new ArrayList<String>(10);
        ArrayList<String> notMust = new ArrayList<String>(10);
        for (IncomeBillControlDTO controlDTO : controlList) {
            String fieldKey = controlDTO.getFieldKey();
            Control control = this.getView().getControl(fieldKey);
            if (control instanceof FieldEdit) {
                if ("issuetype".equals(fieldKey)) {
                    this.setIssueType(controlDTO);
                }
                if (isNeedSetValue) {
                    handle.setValue(this.getView(), fieldKey, controlDTO.getValue(), Boolean.FALSE);
                }
            } else if (control instanceof Label) {
                handle.setLabValue(this.getView(), fieldKey, String.valueOf(controlDTO.getValue()));
            } else if (control instanceof AttachmentPanel && (controlDTO.getValue() == null || !((Boolean)controlDTO.getValue()).booleanValue())) {
                AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanel");
                List attachmentAttachmentData = attachment.getAttachmentData();
                attachmentAttachmentData.forEach(arg_0 -> ((AttachmentPanel)attachment).remove(arg_0));
            }
            Boolean isEnable = controlDTO.getEnable();
            Boolean isVisible = controlDTO.getVisible();
            Boolean isMust = controlDTO.getMust();
            this.setControlList(isEnable, enable, disEnable, fieldKey);
            this.setControlList(isVisible, show, hide, fieldKey);
            this.setControlList(isMust, must, notMust, fieldKey);
        }
        handle.setEnable(this.getView(), enable, Boolean.TRUE);
        handle.setEnable(this.getView(), disEnable, Boolean.FALSE);
        handle.setVisible(this.getView(), show, Boolean.TRUE);
        handle.setVisible(this.getView(), hide, Boolean.FALSE);
        handle.setMustInput(this.getView(), must, Boolean.TRUE);
        handle.setMustInput(this.getView(), notMust, Boolean.FALSE);
    }

    private void setControlList(Boolean isCan, List<String> can, List<String> disCan, String fieldKey) {
        if (isCan == null) {
            return;
        }
        if (isCan.booleanValue()) {
            can.add(fieldKey);
        } else {
            disCan.add(fieldKey);
        }
    }

    private void initData() {
        DynamicObject billData = this.getModel().getDataEntity();
        Long billId = billData.getLong("id");
        String billStatus = billData.getString("billstatus");
        IFormView view = this.getView();
        this.setBtn(billData);
        this.setFlex(Boolean.TRUE);
        if (billId != 0L && !billData.getBoolean("isuploadtpl") && billData.getDynamicObject("printtpl") == null) {
            view.showMessage(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillPlugin_0", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
        }
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            this.isEdit(Boolean.TRUE);
            if (billId != 0L) {
                DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
                if (incomeTpl == null) {
                    view.showMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6536\u5165\u8bc1\u660e\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"IncomeProofDetailPlugin_1", (String)"swc-hcss-formplugin", (Object[])new Object[0]));
                    return;
                }
                MutableGraph fieldControlGraph = this.incomeProofBillService.getFieldControlGraph();
                IncomeBillControlDTO changeField = new IncomeBillControlDTO("applyreason");
                LinkedHashMap resultMap = new LinkedHashMap(16);
                this.incomeProofBillService.fieldInitData(changeField, billData, fieldControlGraph, resultMap);
                ArrayList<IncomeBillControlDTO> controlList = new ArrayList<IncomeBillControlDTO>(resultMap.values());
                this.setFieldValue(controlList, false);
            }
        } else {
            this.isEdit(Boolean.FALSE);
            this.setBillStatus(billData);
            this.setFlexOpenOrClose(Boolean.FALSE);
            this.setApprovalRecord(billData.getString("id"));
            this.setAttachment(billData.getLong("id"));
        }
    }

    private void isEdit(Boolean isEdit) {
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("modifyflex"), isEdit);
        viewHandle.setVisible(this.getView(), Collections.singletonList("viewflex"), Boolean.valueOf(isEdit == false));
    }

    private void setApprovalRecord(String billId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizKey = (String)formShowParameter.getCustomParam("businessKey");
        String type = (String)formShowParameter.getCustomParam("type");
        Boolean isShow = SWCStringUtils.isEmpty((String)bizKey) || SWCStringUtils.isNotEmpty((String)bizKey) && "handled".equals(type);
        FieldsHandle handle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setVisible(this.getView(), Arrays.asList("approvaltitle", "approvalflex"), isShow);
        if (isShow.booleanValue()) {
            handle.approvalRecordHideChat(this.getView(), "approvalrecordap", billId);
        }
    }

    private void setAttachment(Long billId) {
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachment.bindData(this.incomeProofBillService.getAttachmentData("hcss_incomeproofbill", billId));
    }

    private void setAttachmentHandle(Long billId) {
        AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachmentpanelhandle");
        attachment.bindData(this.incomeProofBillService.getDealAttachmentData(billId));
    }

    private void setFiledVisible(DynamicObject billData, List<String> showList) {
        Long receiveWayId;
        boolean isUpload = billData.getBoolean("isuploadtpl");
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        ArrayList<String> hideFiledList = new ArrayList<String>(10);
        if (isUpload) {
            hideFiledList.add("flexprinttpl");
        } else {
            hideFiledList.add("flexisuploadtpl");
            hideFiledList.add("flexattachmentpanel");
        }
        String issueType = billData.getString("issuetype");
        if ("1".equals(issueType)) {
            hideFiledList.add("flexissuenum");
            hideFiledList.add("flexreceiveway");
        }
        if (!(receiveWayId = Long.valueOf(billData.getLong("receiveway.id"))).equals(RECEIVEWAY_MAIL)) {
            hideFiledList.add("flexrecipient");
            hideFiledList.add("flexrecipientphone");
            hideFiledList.add("flexrecipientaddress");
        }
        showList.removeAll(hideFiledList);
        viewHandle.setVisible(this.getView(), hideFiledList, Boolean.FALSE);
        viewHandle.setLabValue(this.getView(), "recipientaddresslab", billData.getString("recipientaddress.name"));
    }

    private void setBillStatus(DynamicObject billData) {
        String billStatus = billData.getString("billstatus");
        ArrayList statusList = new ArrayList(BILLSTATUSLIST);
        statusList.remove(billStatus);
        List labList = statusList.stream().map(String::toLowerCase).collect(Collectors.toList());
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), labList, Boolean.FALSE);
        viewHandle.setVisible(this.getView(), Collections.singletonList(billStatus.toLowerCase()), Boolean.TRUE);
    }

    private void setBtn(DynamicObject billData) {
        List dealAttachmentData;
        String billStatus = billData.getString("billstatus");
        List<String> showButtons = BUTTON_MAP.get(billStatus);
        ArrayList hideButtons = new ArrayList(10);
        BUTTON_MAP.forEach((field, list) -> {
            if (!field.equals(billStatus)) {
                hideButtons.addAll(list);
            }
        });
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), hideButtons, Boolean.FALSE);
        viewHandle.setVisible(this.getView(), showButtons, Boolean.TRUE);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizKey = (String)formShowParameter.getCustomParam("businessKey");
        viewHandle.setVisible(this.getView(), Collections.singletonList("btnflex"), Boolean.valueOf(SWCStringUtils.isEmpty((String)bizKey) && CollectionUtils.isNotEmpty(showButtons)));
        if ("C".equals(billStatus) && "1".equals(billData.getString("issuetype")) && !(dealAttachmentData = this.incomeProofBillService.getDealAttachmentData(Long.valueOf(billData.getLong("id")))).isEmpty()) {
            viewHandle.setVisible(this.getView(), Collections.singletonList("attachmentpanelhandle"), Boolean.TRUE);
            this.setAttachmentHandle(billData.getLong("id"));
        }
    }

    private void setFlex(Boolean isShowContent) {
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        viewHandle.setVisible(this.getView(), Collections.singletonList("perchflex"), Boolean.valueOf(isShowContent == false));
        viewHandle.setVisible(this.getView(), Collections.singletonList("contentflex"), isShowContent);
    }

    private void setFlexOpenOrClose(Boolean isOpen) {
        IViewHandle viewHandle = this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        ArrayList showList = Lists.newArrayList((Object[])new String[]{"flexisuploadtpl", "flexattachmentpanel", "flexprinttpl", "flexissuetype", "flexgetdate", "flexattachmentpanel", "flexorg", "flexrecipient", "flexrecipientphone", "flexrecipientaddress", FLEXDESC, "flexissuenum"});
        List<String> controlList = Arrays.asList(CLOSE, FLEXDESC, "flexgetdate", "flexattachmentpanel", "flexorg", "flexrecipient", "flexrecipientphone", "flexrecipientaddress");
        showList.removeAll(controlList);
        viewHandle.setVisible(this.getView(), controlList, isOpen);
        viewHandle.setVisible(this.getView(), Collections.singletonList(OPEN), Boolean.valueOf(isOpen == false));
        this.setFiledVisible(this.getModel().getDataEntity(), showList);
        viewHandle.setVisible(this.getView(), (List)showList, Boolean.TRUE);
    }

    private void openSubmitSuccessPage(Long billId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setTargetKey("perchflex");
        parameter.setCustomParam("incomeproofbill", (Object)billId);
        this.getViewHandle(HandleTypeEnum.FORM_HANDLE).showForm((FormShowParameter)parameter, "hcss_incomeproofsuccess", ShowType.InContainer, null, null);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setIssueType(String issueTypeLabValue) {
        DynamicObject billData = this.getModel().getDataEntity();
        String issueTypeValue = billData.getString("issuetype");
        if (issueTypeLabValue.equals(issueTypeValue)) {
            return;
        }
        IncomeBillControlDTO issueTypeControl = new IncomeBillControlDTO("issuetype");
        issueTypeControl.setValue((Object)issueTypeLabValue);
        this.setIssueType(issueTypeControl);
        FieldsHandle handle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        handle.setValue(this.getView(), "issuetype", (Object)issueTypeLabValue, Boolean.TRUE);
    }

    private void setIssueType(IncomeBillControlDTO issueTypeControl) {
        FieldsHandle handle = (FieldsHandle)this.getViewHandle(HandleTypeEnum.FIELDS_HANDLE);
        List issueTypeList = this.incomeProofBillService.getIncomeBillMobileIssueType(issueTypeControl);
        Boolean isVisible = Boolean.FALSE;
        for (IncomeBillIssueTypeDTO issueType : issueTypeList) {
            String key = issueType.getIssueType();
            Boolean show = issueType.getShow();
            isVisible = isVisible != false ? isVisible : show;
            handle.setVisible(this.getView(), Collections.singletonList(key), show);
            handle.setControlCustomStyles(this.getView(), key, issueType.getCss());
            this.getView().updateView(key);
        }
        handle.setVisible(this.getView(), Collections.singletonList("issuetypeflex"), isVisible);
    }
}

