/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.common.entity;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcss.common.entity.CurrencyDTO;
import kd.swc.hcss.common.entity.ExchangeRateDetailDTO;

public class RevenueFieldCalResult
implements Cloneable {
    private static final Log log = LogFactory.getLog(RevenueFieldCalResult.class);
    private static final RevenueFieldCalResult INSTANCE = new RevenueFieldCalResult(0L, "", 0, "", null, "");
    private CurrencyDTO currency;
    private BigDecimal value;
    private String showValue;
    private Map<Long, ExchangeRateDetailDTO> rateInfoMap = new HashMap<Long, ExchangeRateDetailDTO>(16);

    public static RevenueFieldCalResult getInstance() {
        return INSTANCE;
    }

    public RevenueFieldCalResult(Long currencyId, String currencyName, Integer scale, String sign, BigDecimal value, String showValue) {
        this.currency = new CurrencyDTO(currencyId, currencyName, scale, sign);
        this.value = value;
        this.showValue = showValue;
    }

    public CurrencyDTO getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyDTO currency) {
        this.currency = currency;
    }

    public Long getCurrencyId() {
        return this.currency.getCurrencyId();
    }

    public Integer getScale() {
        return this.currency.getScale();
    }

    public String getCurrencyName() {
        return this.currency.getCurrencyName();
    }

    public String getSign() {
        return this.currency.getSign();
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public Map<Long, ExchangeRateDetailDTO> getRateInfoMap() {
        return this.rateInfoMap;
    }

    public void setRateInfoMap(Map<Long, ExchangeRateDetailDTO> rateInfoMap) {
        this.rateInfoMap = rateInfoMap;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public void setShowValue(String showValue) {
        this.showValue = showValue;
    }

    public void addRateInfo(Long currencyId, ExchangeRateDetailDTO rateInfo) {
        if (this.rateInfoMap == null) {
            this.rateInfoMap = new HashMap<Long, ExchangeRateDetailDTO>(16);
        }
        if (!this.getCurrencyId().equals(currencyId)) {
            this.rateInfoMap.put(currencyId, rateInfo);
        }
    }

    public void addValue(BigDecimal add) {
        if (add == null) {
            return;
        }
        if (this.value == null) {
            this.value = BigDecimal.ZERO;
        }
        this.value = this.value.add(add);
    }

    public RevenueFieldCalResult clone() {
        RevenueFieldCalResult result = null;
        try {
            result = (RevenueFieldCalResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("RevenueFieldCalResult clone error", (Throwable)e);
        }
        return result;
    }
}

