/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.common.enums;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hsbp.common.util.SWCStringUtils;

public enum IncomeProofStatusEnum implements IncomeProofCommon
{
    BEGIN_CHECK_APPROVE("begincheckapprove", "D", "default_status", "A"),
    BEGIN_CHECK_APPROVE_CUSTOM("begincheckapprove", "D", "default_status", "default_status"),
    SAVE_INCOMEINFO("saveincomeinfo", "default_status", "default_status", "B"),
    AUTO_CAL("autocal", "default_status", "default_status", "default_status"),
    AGREE("wfauditpass", "C", "C", "I"),
    SIGN_ING("signing", "default_status", "default_status", "L"),
    SIGNBACK_SUCCESS("signsuccess", "default_status", "default_status", "K"),
    SIGNBACK_FAIL("signsuccess", "default_status", "default_status", "F"),
    AUTO_SIGN_SUCCESS("autosign", "default_status", "default_status", "L"),
    AUTO_SIGN_FAIL("autosign", "default_status", "default_status", "F"),
    STOP("wfauditnotpass", "E", "H", "S"),
    UNSUBMIT("unsubmitmob", "A", "A", null),
    UNSUBMITPC("unsubmit", "A", "A", null),
    REJECT_SUBMIT("wfrejecttosubmit", "G", "A", null),
    ABANDON("abandonmob", "F", "F", "S"),
    ABANDONPC("abandoned", "F", "F", "S"),
    FIRM_COMMIT("firmcommit", "default_status", "default_status", "C"),
    ISSUED("issued", "default_status", "default_status", "K"),
    RE_SIGN_FAIL("resign", "default_status", "default_status", "F"),
    RE_SIGN_SUCCESS("resign", "default_status", "default_status", "L"),
    RECEIVED("received", "default_status", "default_status", "K"),
    RECEIVED_DEAL("receiveddeal", "default_status", "default_status", "K");

    private final String operationCode;
    private final String billStatus;
    private final String auditStatus;
    private final String dealStatus;

    private IncomeProofStatusEnum(String operationCode, String billStatus, String auditStatus, String dealStatus) {
        this.operationCode = operationCode;
        this.billStatus = billStatus;
        this.auditStatus = auditStatus;
        this.dealStatus = dealStatus;
    }

    public String getOperationCode() {
        return this.operationCode;
    }

    public String getBillStatus() {
        return this.billStatus;
    }

    public String getAuditStatus() {
        return this.auditStatus;
    }

    public String getDealStatus() {
        return this.dealStatus;
    }

    public static List<IncomeProofStatusEnum> getOperationEnumList(String operationCode) {
        IncomeProofStatusEnum[] incomeProofStatusEnums;
        if (operationCode == null) {
            return Collections.emptyList();
        }
        ArrayList<IncomeProofStatusEnum> list = new ArrayList<IncomeProofStatusEnum>(10);
        for (IncomeProofStatusEnum incomeProofStatusEnum : incomeProofStatusEnums = IncomeProofStatusEnum.values()) {
            if (!SWCStringUtils.equals((String)incomeProofStatusEnum.getOperationCode(), (String)operationCode)) continue;
            list.add(incomeProofStatusEnum);
        }
        return list;
    }
}

