/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.opplugin.validator.incometpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.helper.CueHelper;
import kd.swc.hcss.business.service.income.AppliyReasonService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.common.common.HcssCommon;
import kd.swc.hcss.common.common.IncomeProofTplCommon;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class IncomeProofTplValidator
extends SWCDataBaseValidator
implements IncomeProofTplCommon,
HcssCommon {
    private AppliyReasonService appliyReasonService = (AppliyReasonService)DomainFactory.getInstance(AppliyReasonService.class);
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkData(dataEntity);
        }
    }

    private void checkData(ExtendedDataEntity dataEntity) {
        boolean isUploadTpl;
        Long econTplId;
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection collection = data.getDynamicObjectCollection("entryentity");
        Map issueTypeMap = this.incomeProofTplService.getIssueTypeMap(data);
        Boolean isElecHasConfig = issueTypeMap.getOrDefault("iselecissue", Boolean.FALSE);
        Boolean isPageHasConfig = issueTypeMap.getOrDefault("ispageissue", Boolean.FALSE);
        if (!isElecHasConfig.booleanValue() && !isPageHasConfig.booleanValue()) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u5177\u5f62\u5f0f\u201d\u3002", (String)"IncomeProofTplValidator_4", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
        }
        if (isElecHasConfig.booleanValue() && isPageHasConfig.booleanValue()) {
            boolean isHasConfig = false;
            for (DynamicObject entry2 : collection) {
                econTplId = entry2.getLong("econtpl.id");
                if (econTplId.equals(0L)) continue;
                isHasConfig = true;
                break;
            }
            if (!isHasConfig) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4e3a\u4e00\u4e2a\u6253\u5370\u6a21\u677f\u7ef4\u62a4\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u3002", (String)"IncomeProofTplValidator_0", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
            }
        }
        if (isPageHasConfig.booleanValue()) {
            DynamicObjectCollection receiveWayCol = data.getDynamicObjectCollection("receivewayentry");
            if (receiveWayCol.isEmpty()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7eb8\u8d28\u8bc1\u660e\u9886\u53d6\u65b9\u5f0f\u914d\u7f6e\u201d\u3002", (String)"IncomeProofTplValidator_8", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
            } else {
                List receiveWayNames = receiveWayCol.stream().filter(receiveWay -> !"1".equals(receiveWay.getString("receiveway.enable"))).map(receiveWay -> receiveWay.getString("receiveway.name")).collect(Collectors.toList());
                if (!receiveWayNames.isEmpty()) {
                    this.addFatalErrorMessage(dataEntity, CueHelper.splicingCue((String)ResManager.loadKDString((String)"\u9886\u53d6\u65b9\u5f0f%s\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IncomeProofTplValidator_9", (String)"swc-hcss-opplugin", (Object[])new Object[0]), (Collection)receiveWayNames));
                }
            }
        }
        if (isElecHasConfig.booleanValue() && !isPageHasConfig.booleanValue()) {
            boolean isNotHasConfig = false;
            for (DynamicObject entry2 : collection) {
                econTplId = entry2.getLong("econtpl.id");
                if (!econTplId.equals(0L)) continue;
                isNotHasConfig = true;
                break;
            }
            if (isNotHasConfig) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5f00\u5177\u7535\u5b50\u8bc1\u660e\u65f6\uff0c\u8bf7\u4e3a\u6240\u6709\u6253\u5370\u6a21\u677f\u7ef4\u62a4\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u3002", (String)"IncomeProofTplValidator_3", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
            }
        }
        Set reasonIdSet = this.appliyReasonService.queryUsedApplyReasonIdSet(Long.valueOf(data.getLong("org.id")));
        DynamicObjectCollection reasonCollection = data.getDynamicObjectCollection("reason");
        List reasonNameList = reasonCollection.stream().filter(reason -> !reasonIdSet.contains(reason.getLong("fbasedataid.id"))).map(reason -> reason.getString("fbasedataid.name")).collect(Collectors.toList());
        if (reasonNameList.contains(null)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8bc1\u660e\u7528\u9014\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IncomeProofTplValidator_5", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
            reasonNameList.remove(null);
        }
        if (!reasonNameList.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, CueHelper.splicingCue((String)ResManager.loadKDString((String)"\u8bc1\u660e\u7528\u9014%s\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IncomeProofTplValidator_1", (String)"swc-hcss-opplugin", (Object[])new Object[0]), reasonNameList));
        }
        if (!(isUploadTpl = data.getBoolean("isuploadtpl"))) {
            Map<Long, String> reasonMap = reasonCollection.stream().filter(reason -> reasonIdSet.contains(reason.getLong("fbasedataid.id"))).collect(Collectors.toMap(reason -> reason.getLong("fbasedataid.id"), reason -> reason.getString("fbasedataid.name")));
            collection.forEach(entry -> {
                DynamicObjectCollection reasonMul = entry.getDynamicObjectCollection("mulreasonentry");
                reasonMul.forEach(reason -> {
                    Long reasonId = reason.getLong("fbasedataid.id");
                    reasonMap.remove(reasonId);
                });
            });
            reasonNameList = new ArrayList<String>(reasonMap.values());
            if (!reasonNameList.isEmpty()) {
                this.addFatalErrorMessage(dataEntity, CueHelper.splicingCue((String)ResManager.loadKDString((String)"\u8bf7\u4e3a\u8bc1\u660e\u7528\u9014%s\u6307\u5b9a\u6253\u5370\u6a21\u677f\u3002", (String)"IncomeProofTplValidator_2", (String)"swc-hcss-opplugin", (Object[])new Object[0]), reasonNameList));
            }
        }
        List enablePrintTplIds = this.incomeProofTplService.getEnablePrintTplIds();
        List printNameList = collection.stream().filter(entry -> !enablePrintTplIds.contains(entry.getString("printtpl.id"))).map(entry -> entry.getString("printtpl.name")).collect(Collectors.toList());
        if (printNameList.contains(null)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u5b9a\u7684\u6253\u5370\u6a21\u677f\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IncomeProofTplValidator_6", (String)"swc-hcss-opplugin", (Object[])new Object[0]));
            printNameList.remove(null);
        }
        if (!printNameList.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, CueHelper.splicingCue((String)ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f%s\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IncomeProofTplValidator_7", (String)"swc-hcss-opplugin", (Object[])new Object[0]), printNameList));
        }
    }
}

