/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.handle.ViewHandleFactory;
import kd.swc.hcss.business.handle.action.FormHandle;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hcss.mservice.api.IShareService;

public class ShareService
implements IShareService {
    private static final Log logger = LogFactory.getLog(ShareService.class);
    String BTNKEY = "btnkey";
    String BTNNAME = "btnname";
    String OPKEY = "opkey";
    private final IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);
    private static final String RESOURCES = "swc-hcss-mservice";

    public Map<String, Object> invokeOperation(String pageId, String opkey, OperateOption operateOption) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        if (formView == null) {
            return Collections.emptyMap();
        }
        OperationResult operationResult = operateOption == null ? formView.invokeOperation(opkey) : formView.invokeOperation(opkey, operateOption);
        List acts = new ArrayList(0);
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        if (clientViewProxy != null) {
            acts = clientViewProxy.getActionResult();
        }
        resultMap.put("operationResult", operationResult);
        resultMap.put("acts", acts);
        return resultMap;
    }

    public Map<String, Object> getButtonViewByActivityId(Map<String, Object> paramMap) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        HashMap showInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            DynamicObject incomeproofBill;
            Long activityId = Long.valueOf(String.valueOf(paramMap.get("activityId")));
            String activityNumber = String.valueOf(paramMap.get("activityNumber"));
            if ("hcss_incomeproofbill".equals(activityNumber) && (incomeproofBill = BusinessDataServiceHelper.loadSingle((Object)activityId, (String)activityNumber)) != null) {
                String showFormNum = "hcss_incomeproof_ssc";
                showInfoMap.put("showform", showFormNum);
                String dealStatus = incomeproofBill.getString("dealstatus");
                String isUpload = incomeproofBill.getString("isuploadtpl");
                String issueType = incomeproofBill.getString("issuetype");
                ArrayList buttonInfos = Lists.newArrayListWithCapacity((int)16);
                String[] btnArray = new String[]{dealStatus, isUpload, issueType};
                Map buttonsMap = this.incomeProofBillService.showHideButtons(btnArray);
                List showButtons = (List)buttonsMap.get("showButtons");
                this.putButtonInfos(showButtons, buttonInfos, dealStatus);
                showInfoMap.put("buttons", buttonInfos);
                HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
                customParams.put("dealStatus", dealStatus);
                showInfoMap.put("customParams", customParams);
            }
            rpcResult.put("data", showInfoMap);
            rpcResult.put("success", Boolean.TRUE);
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    private void putButtonInfos(List<String> showButtons, List<Map<String, Object>> buttonInfos, String dealStatus) {
        HashMap<String, String> claimedMap;
        HashMap<String, String> firmCommitMap;
        if (showButtons.contains("save") || "B".equals(dealStatus)) {
            firmCommitMap = new HashMap<String, String>();
            firmCommitMap.put(this.BTNKEY, "save");
            firmCommitMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ShareService_0", (String)RESOURCES, (Object[])new Object[0]));
            firmCommitMap.put(this.OPKEY, "saveincomeinfo");
            buttonInfos.add(firmCommitMap);
        }
        if (showButtons.contains("modify")) {
            firmCommitMap = new HashMap();
            firmCommitMap.put(this.BTNKEY, "modify");
            firmCommitMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u4fee\u6539", (String)"ShareService_1", (String)RESOURCES, (Object[])new Object[0]));
            firmCommitMap.put(this.OPKEY, "modify");
            buttonInfos.add(firmCommitMap);
        }
        if (showButtons.contains("firmcommit")) {
            firmCommitMap = new HashMap();
            firmCommitMap.put(this.BTNKEY, "firmcommit");
            firmCommitMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u786e\u8ba4\u63d0\u4ea4", (String)"ShareService_2", (String)RESOURCES, (Object[])new Object[0]));
            firmCommitMap.put(this.OPKEY, "firmcommit");
            buttonInfos.add(firmCommitMap);
        }
        if (showButtons.contains("issued")) {
            HashMap<String, String> issuedMap = new HashMap<String, String>();
            issuedMap.put(this.BTNKEY, "issued");
            issuedMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u6253\u5370\u7eb8\u8d28\u8bc1\u660e", (String)"ShareService_3", (String)RESOURCES, (Object[])new Object[0]));
            issuedMap.put(this.OPKEY, "issued");
            buttonInfos.add(issuedMap);
        }
        if (showButtons.contains("receiveddeal")) {
            HashMap<String, String> receiveddealMap = new HashMap<String, String>();
            receiveddealMap.put(this.BTNKEY, "receiveddeal");
            receiveddealMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u786e\u8ba4\u5df2\u5f00\u5177", (String)"ShareService_4", (String)RESOURCES, (Object[])new Object[0]));
            receiveddealMap.put(this.OPKEY, "receiveddeal");
            buttonInfos.add(receiveddealMap);
        }
        if (showButtons.contains("claimed")) {
            claimedMap = new HashMap<String, String>();
            claimedMap.put(this.BTNKEY, "claimed");
            claimedMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u901a\u77e5\u9886\u53d6", (String)"ShareService_5", (String)RESOURCES, (Object[])new Object[0]));
            claimedMap.put(this.OPKEY, "claimed");
            buttonInfos.add(claimedMap);
        }
        if (showButtons.contains("resign")) {
            claimedMap = new HashMap();
            claimedMap.put(this.BTNKEY, "resign");
            claimedMap.put(this.BTNNAME, ResManager.loadKDString((String)"\u91cd\u65b0\u7b7e\u7f72", (String)"ShareService_7", (String)RESOURCES, (Object[])new Object[0]));
            claimedMap.put(this.OPKEY, "resign");
            buttonInfos.add(claimedMap);
        }
    }

    private boolean isMatch(String[] btnArray, String[] array) {
        if (btnArray.length != array.length) {
            return false;
        }
        for (int index = 0; index < btnArray.length; ++index) {
            String value = array[index];
            if (value == null || value.equals(btnArray[index])) continue;
            return false;
        }
        return true;
    }

    public Map<String, Object> firmCommitValidator(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            String opNumber = String.valueOf(params.get("opNumber"));
            DynamicObject dynamicObject = (DynamicObject)params.get("currentViewDy");
            BaseResult baseResult = this.incomeProofBillService.decorator(opNumber).beforeOperation(dynamicObject);
            rpcResult.put("msg", baseResult.getMessage());
            rpcResult.put("success", baseResult.isSuccess());
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService firmCommitValidator error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> listValidator(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            String opNumber = String.valueOf(params.get("opNumber"));
            IFormPlugin formPlugin = (IFormPlugin)params.get("formPlugin");
            ListSelectedRowCollection listSelectedData = (ListSelectedRowCollection)params.get("listSelectedData");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", "hstc");
            BaseResult baseResult = this.incomeProofBillService.decorator(opNumber).beforeOperation(listSelectedData, operateOption, (AbstractFormPlugin)formPlugin);
            rpcResult.put("msg", baseResult.getMessage());
            rpcResult.put("data", baseResult.getData());
            rpcResult.put("success", baseResult.isSuccess());
            logger.error("invoke hcss ShareService listValidator baseResult :{}", JSON.toJSON((Object)baseResult));
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService listValidator error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> dataValidator(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            String opNumber = String.valueOf(params.get("opNumber"));
            String formPlugin = (String)params.get("formPluginName");
            AbstractFormPlugin abstractFormPlugin = new AbstractFormPlugin();
            abstractFormPlugin.setPluginName(formPlugin);
            DynamicObject dynamicObject = (DynamicObject)params.get("currentViewDy");
            BaseOperation decorator = this.incomeProofBillService.decorator(opNumber);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", "hstc");
            BaseResult baseResult = decorator.beforeOperation(dynamicObject, operateOption, abstractFormPlugin);
            rpcResult.put("msg", baseResult.getMessage());
            rpcResult.put("data", baseResult.getData());
            rpcResult.put("success", baseResult.isSuccess());
            logger.error("invoke hcss ShareService dataValidator baseResult :{}", JSON.toJSON((Object)baseResult));
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService dataValidator error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> downUrls(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            List successIds = (List)params.get("successIds");
            List downUrls = this.incomeProofBillService.getDownUrls(successIds);
            rpcResult.put("data", downUrls);
            rpcResult.put("success", Boolean.TRUE);
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService downUrls error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> firmCommit(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreFlag", "1");
            String opNumber = String.valueOf(params.get("opNumber"));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)opNumber, (String)"hcss_incomeproofhandle", (Object[])new Object[]{params.get("id")}, (OperateOption)OperateOption.create());
            if (operationResult != null) {
                rpcResult.put("msg", operationResult.getMessage());
                rpcResult.put("operationResult", operationResult);
                rpcResult.put("success", operationResult.isSuccess());
                return rpcResult;
            }
            rpcResult.put("success", Boolean.TRUE);
            rpcResult.put("msg", ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ShareService_6", (String)RESOURCES, (Object[])new Object[0]));
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService firmCommit error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> viewissuelog(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            QFilter filterList = (QFilter)params.get("filterList");
            IFormPlugin formPlugin = (IFormPlugin)params.get("formPlugin");
            IViewHandle handle = ViewHandleFactory.getHandle((HandleTypeEnum)HandleTypeEnum.FORM_HANDLE);
            ListShowParameter parameter = new ListShowParameter();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
            map.put("isSelect", filterList != null);
            ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
            listFilterParameter.setFilter(filterList);
            handle.showForm((FormShowParameter)parameter, "hcss_issueprooflog", ShowType.MainNewTabPage, new CloseCallBack(formPlugin, "hcss_issueprooflog"), map);
            rpcResult.put("listShowParameter", parameter);
            rpcResult.put("success", Boolean.TRUE);
            rpcResult.put("msg", ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ShareService_6", (String)RESOURCES, (Object[])new Object[0]));
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService firmCommit error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> previewIncomeProof(Map<String, Object> params) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            String pageId = String.valueOf(params.get("pageId"));
            OperationResult operationResult = (OperationResult)params.get("operationResult");
            String opNumber = String.valueOf(params.get("opNumber"));
            BaseResult baseResult = this.incomeProofBillService.decorator(opNumber).afterOperation(operationResult);
            if (!baseResult.isSuccess()) {
                rpcResult.put("success", Boolean.FALSE);
                rpcResult.put("msg", baseResult.getMessage());
                return rpcResult;
            }
            Map printBillMap = (Map)baseResult.getData();
            String taskId = this.incomeProofBillService.getPreviewIncomeProofBillPdfTaskId();
            List attachList = this.incomeProofBillService.getPreviewIncomeProofBillPdfAttachList(taskId, printBillMap, pageId);
            List paras = FormHandle.printPreview((String)taskId, (List)attachList);
            rpcResult.put("paras", paras);
            rpcResult.put("success", Boolean.TRUE);
            rpcResult.put("msg", null);
        }
        catch (Exception exception) {
            logger.error("invoke hcss ShareService firmCommit error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }
}

