/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.cronjob;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public abstract class AbstractUpdateDataTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(AbstractUpdateDataTask.class);
    private String algoKey;
    private DBRoute dbRoute;
    private String sql;
    protected DataSet rows = null;
    private int queryBatch = 0;

    public void setAlgoKey(String algoKey) {
        this.algoKey = algoKey;
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getAlgoKey() {
        return this.algoKey;
    }

    public DBRoute getDbRoute() {
        return this.dbRoute;
    }

    public String getSql() {
        return this.sql;
    }

    public abstract void dealUpdateData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String simpleName = ((Object)((Object)this)).getClass().getSimpleName();
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateDataTask();
            }
        }
        catch (Exception e) {
            LOGGER.error(simpleName, (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOGGER.info(simpleName, (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updateDataTask() {
        LOGGER.info("start to deal \uff1a{}", (Object)this.algoKey);
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)this.algoKey, (DBRoute)this.dbRoute, (String)this.sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)this.algoKey, (DBRoute)this.dbRoute, (String)this.sql);
            this.queryBatch = 0;
            LOGGER.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        this.dealUpdateData();
        ++this.queryBatch;
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

