/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.cronjob;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.cronjob.AbstractUpdateDataTask;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hsbp.common.constants.SWCConstants;

public class IncomeProofBillUpdatePersonContactTask
extends AbstractUpdateDataTask {
    private static final int BATCH_SIZE = 5000;
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public IncomeProofBillUpdatePersonContactTask() {
        this.setAlgoKey("IncomeProofBillUpdatePersonContactTask");
        this.setDbRoute(SWCConstants.SWC_ROUETE);
        this.setSql("select fid,fpersonid from t_hcss_incomeproofbill where fpercontactid = 0 or fpercontactid IS null ");
    }

    @Override
    public void dealUpdateData() {
        int count = 0;
        HashSet<Long> personSet = new HashSet<Long>(10);
        HashMap personToBillMap = Maps.newHashMapWithExpectedSize((int)5000);
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            Long personId = row.getLong("fpersonid");
            personSet.add(personId);
            List billIds = personToBillMap.getOrDefault(personId, new ArrayList());
            billIds.add(id);
            personToBillMap.put(personId, billIds);
            if (++count < 5000) continue;
            break;
        }
        if (personToBillMap.isEmpty()) {
            return;
        }
        List<Map<String, Object>> listBatchPersonContact = this.incomeProofBillService.getListBatchPersonContact(new ArrayList<Long>(personSet));
        HashMap<Object, Object> personIdToObjMap = new HashMap<Object, Object>(16);
        for (Map<String, Object> personContact : listBatchPersonContact) {
            personIdToObjMap.put(personContact.get("person_id"), personContact.get("id"));
        }
        this.updateBillPersonContact(personToBillMap, personIdToObjMap);
    }

    private void updateBillPersonContact(Map<Long, List<Long>> personToBillMap, Map<Object, Object> personIdToObjMap) {
        String updateSql = "update t_hcss_incomeproofbill set fpercontactid = ? where fid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, List<Long>> entry : personToBillMap.entrySet()) {
            Object[] obj;
            Long personID = entry.getKey();
            List<Long> billIds = entry.getValue();
            Object perContactId = personIdToObjMap.get(personID);
            if (perContactId == null) {
                for (Long billId : billIds) {
                    obj = new Object[]{-1L, billId};
                    updateList.add(obj);
                }
                continue;
            }
            for (Long billId : billIds) {
                obj = new Object[]{perContactId, billId};
                updateList.add(obj);
            }
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateList);
    }
}

