/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.cronjob;

import java.util.ArrayList;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hcss.business.cronjob.AbstractUpdateDataTask;
import kd.swc.hcss.business.util.DynamicTransformUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class SchemeUpdateReceiveEntryTask
extends AbstractUpdateDataTask {
    private static final int BATCH_SIZE = 5000;

    public SchemeUpdateReceiveEntryTask() {
        this.setAlgoKey("SchemeUpdateReceiveEntryTask");
        this.setDbRoute(SWCConstants.SWC_ROUETE);
        this.setSql("select fid from t_hcss_incomeprooftpl where fissuetype like '%,0,%'");
    }

    @Override
    public void dealUpdateData() {
        DynamicObject[] dataArray;
        ArrayList<Long> ids = new ArrayList<Long>(10);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            ids.add(id);
            if (++count < 5000) continue;
            break;
        }
        if (ids.isEmpty()) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcss_incomeproofscheme");
        QFilter filter = new QFilter("id", "in", ids);
        for (DynamicObject data : dataArray = helper.loadDynamicObjectArray(filter.toArray())) {
            DynamicObjectCollection receiveWayEntry = data.getDynamicObjectCollection("receivewayentry");
            if (!receiveWayEntry.isEmpty()) continue;
            DynamicObject entry = helper.generateEmptyEntryDynamicObject("receivewayentry");
            entry.set("seq", (Object)1);
            entry.set("receiveway", (Object)DynamicTransformUtils.getDynamicObjectById("hcss_receiveway", 1010L));
            receiveWayEntry.add((Object)entry);
        }
        helper.save(dataArray);
    }
}

