/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.dao;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hcss.business.handle.DataHandleFactory;
import kd.swc.hcss.business.handle.orm.IDataHandle;
import kd.swc.hcss.common.common.HcssCommon;
import kd.swc.hcss.common.enums.HandleTypeEnum;

public abstract class BaseHcssDao
implements HcssCommon {
    private String entityName;

    public BaseHcssDao(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public IDataHandle getDataHandle(HandleTypeEnum handleTypeEnum) {
        return DataHandleFactory.getHandle(handleTypeEnum);
    }

    public void saveOrUpdateData(DynamicObject[] dataArray) {
        this.getDataHandle(HandleTypeEnum.DATAHANDLE).save(this.entityName, dataArray);
    }

    public void deleteData(QFilter[] filters) {
        this.getDataHandle(HandleTypeEnum.DATAHANDLE).delete(this.entityName, filters);
    }

    public DynamicObject[] getSaveData(String selectFields, QFilter[] filters, String orderBys) {
        return (DynamicObject[])this.getDataHandle(HandleTypeEnum.DATAHANDLE).queryArray(this.entityName, selectFields, filters, orderBys).getData();
    }

    public DynamicObject[] getSaveData(String selectFields, QFilter[] filters) {
        return this.getSaveData(selectFields, filters, "");
    }

    public DynamicObject getSaveOneData(String selectFields, QFilter[] filters) {
        return (DynamicObject)this.getDataHandle(HandleTypeEnum.DATAHANDLE).queryOne(this.entityName, selectFields, filters).getData();
    }

    public DynamicObjectCollection queryDataCol(String selectFields, QFilter[] filters, String orderBys) {
        return (DynamicObjectCollection)this.getDataHandle(HandleTypeEnum.DATAHANDLE).queryCol(this.entityName, selectFields, filters, orderBys).getData();
    }

    public DynamicObjectCollection queryDataCol(String selectFields, QFilter[] filters) {
        return this.queryDataCol(selectFields, filters, "");
    }

    public DynamicObject queryOneData(String selectFields, QFilter[] filters) {
        return (DynamicObject)this.getDataHandle(HandleTypeEnum.DATAHANDLE).queryOriginalOne(this.entityName, selectFields, filters).getData();
    }
}

