/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.handle.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.url.UrlService;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;

public class FormHandle
implements IViewHandle {
    @Override
    public BaseResult<?> showSecondConfirm(IFormView view, String title, ConfirmCallBackListener confirmCallBacks, String customValue) {
        view.showConfirm(title, null, MessageBoxOptions.OKCancel, null, confirmCallBacks, null, customValue == null ? "" : customValue);
        return BaseResult.success(null);
    }

    public BaseResult<?> dealOperationResult(IFormView view, BaseResult<?> baseResult, ConfirmCallBackListener confirmCallBacks) {
        if (!baseResult.isSuccess()) {
            String message = baseResult.getMessage();
            if (baseResult.isTip()) {
                this.showSecondConfirm(view, message, confirmCallBacks, null);
            } else if (baseResult.isForm()) {
                view.showForm((FormShowParameter)baseResult.getData());
            } else if (baseResult.isErrorTip()) {
                view.showTipNotification(message);
            } else {
                view.showErrorNotification(message);
            }
        }
        return BaseResult.success(null);
    }

    public BaseResult<?> showOperationResultConfirm(IFormView view, ConfirmCallBackListener confirmCallBacks) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"FormHandle_0", (String)"swc-hcss-business", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"FormHandle_1", (String)"swc-hcss-business", (Object[])new Object[0]));
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FormHandle_2", (String)"swc-hcss-business", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        view.showConfirm(msg, view.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        return BaseResult.success(null);
    }

    public BaseResult<FormShowParameter> showForm(FormShowParameter parameter, String formId, ShowType showType, CloseCallBack closeCallBack, Map<String, Object> customParam) {
        if (parameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)parameter;
            listShowParameter.setBillFormId(formId);
            if (parameter instanceof MobileListShowParameter) {
                listShowParameter.setFormId("bos_moblist");
            } else {
                listShowParameter.setFormId("bos_list");
            }
        } else {
            parameter.setFormId(formId);
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParams(customParam);
        return BaseResult.success((Object)parameter);
    }

    @Override
    public BaseResult<?> showOperationResultForm(IFormView view, ErrorLevel level, String operateName, String title, List<String> failList) {
        if (failList.size() == 1) {
            if (ErrorLevel.Warning == level) {
                view.showTipNotification(failList.get(0));
            } else {
                view.showErrorNotification(failList.get(0));
            }
        } else {
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
            view.showForm(parameters);
        }
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<?> invokeOtherViewOperation(IFormView curView, IFormView otherView, String operateName) {
        if (otherView == null) {
            return BaseResult.success(null);
        }
        otherView.invokeOperation(operateName);
        curView.sendFormAction(otherView);
        return BaseResult.success(null);
    }

    public void printPreview(IFormView curView, String taskId, List<PrtTaskResult.Attach> attachList) {
        List<FormShowParameter> paras = FormHandle.printPreview(taskId, attachList);
        if (paras == null) {
            return;
        }
        for (FormShowParameter para : paras) {
            curView.showForm(para);
        }
    }

    public static List<FormShowParameter> printPreview(String taskId, List<PrtTaskResult.Attach> attachList) {
        if (attachList == null) {
            return null;
        }
        ArrayList paras = Lists.newArrayListWithExpectedSize((int)10);
        if (attachList.size() <= 3) {
            for (PrtTaskResult.Attach attach : attachList) {
                String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> reservedSpace = new HashMap<String, String>(16);
                reservedSpace.put("reservedSpace", "true");
                para.getOpenStyle().setCustParam(reservedSpace);
                para.setCustomParam("src", (Object)downloadUrl);
                paras.add(para);
            }
            return paras;
        }
        FormShowParameter para = new FormShowParameter();
        para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"PrintDataProgressFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        para.setFormId("bos_print_resultview");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("taskId", (Object)taskId);
        paras.add(para);
        return paras;
    }
}

