/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.handle.action;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.tree.TreeNode;
import kd.swc.hcss.business.handle.action.IViewHandle;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class TreeViewHandle
implements IViewHandle {
    @Override
    public BaseResult<?> getTreeView(List<TreeNode> treeNodes) {
        List<TreeNode> rootNodes = treeNodes.stream().filter(node -> SWCStringUtils.isEmpty((String)node.getParentid())).collect(Collectors.toList());
        Map<String, List<TreeNode>> rootMap = treeNodes.stream().collect(Collectors.groupingBy(TreeNode::getParentid));
        this.buildTree(rootMap, rootNodes);
        return BaseResult.success(rootNodes);
    }

    private void buildTree(Map<String, List<TreeNode>> rootMap, List<TreeNode> rootNodes) {
        rootNodes.forEach(rootNode -> {
            List treeNodes = (List)rootMap.get(rootNode.getId());
            rootNode.setIsOpened(true);
            rootNode.setChildren(treeNodes);
            if (!CollectionUtils.isEmpty((Collection)treeNodes)) {
                this.buildTree(rootMap, treeNodes);
            }
        });
    }
}

