/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.handle.orm;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.swc.hcss.business.handle.orm.IDataHandle;
import kd.swc.hcss.business.util.DynamicTransformUtils;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataHandle
implements IDataHandle {
    @Override
    public BaseResult<DynamicObject[]> queryArray(String entityName, String selectFields, QFilter[] filters, String orderBys) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.query(selectFields, filters, orderBys));
    }

    @Override
    public BaseResult<DynamicObject> queryOne(String entityName, String selectFields, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject data = helper.queryOne(selectFields, filters);
        return BaseResult.success((Object)data);
    }

    @Override
    public BaseResult<DynamicObjectCollection> queryCol(String entityName, String selectFields, QFilter[] filters, String orderBys) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.queryOriginalCollection(selectFields, filters, orderBys));
    }

    @Override
    public BaseResult<DynamicObject> queryOriginalOne(String entityName, String selectFields, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject data = helper.queryOriginalOne(selectFields, filters);
        return BaseResult.success((Object)data);
    }

    @Override
    public BaseResult<Integer> count(String entityName, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.count(filters));
    }

    @Override
    public BaseResult<Boolean> isExist(String entityName, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.isExists(filters));
    }

    @Override
    public BaseResult<Map> queryMap(String entityName, String selectFields, QFilter[] filters, String keyField, String valueField) {
        BaseResult<DynamicObjectCollection> baseResult = this.queryCol(entityName, selectFields, filters, "");
        if (baseResult.isSuccess() && !((DynamicObjectCollection)baseResult.getData()).isEmpty()) {
            if (SWCStringUtils.isEmpty((String)valueField)) {
                return BaseResult.success(((DynamicObjectCollection)baseResult.getData()).stream().collect(Collectors.toMap(data -> data.get(keyField), data -> data, (oldValue, newValue) -> newValue)));
            }
            return BaseResult.success((Object)((DynamicObjectCollection)baseResult.getData()).stream().collect(HashMap::new, (map, data) -> map.put(data.get(keyField), data.get(valueField)), HashMap::putAll));
        }
        return BaseResult.success((Object)Collections.EMPTY_MAP);
    }

    @Override
    public BaseResult<Map<String, String>> queryStringMap(String entityName, String selectFields, QFilter[] filters, String keyField, String valueField) {
        BaseResult<DynamicObjectCollection> baseResult = this.queryCol(entityName, selectFields, filters, "");
        if (baseResult.isSuccess() && !((DynamicObjectCollection)baseResult.getData()).isEmpty() && !SWCStringUtils.isEmpty((String)valueField)) {
            return BaseResult.success((Object)((DynamicObjectCollection)baseResult.getData()).stream().collect(HashMap::new, (map, data) -> map.put(data.getString(keyField), data.getString(valueField)), HashMap::putAll));
        }
        return BaseResult.success((Object)Collections.EMPTY_MAP);
    }

    @Override
    public BaseResult<Map<String, String>> queryStringMap(String entityName, String selectFields, QFilter[] filters, String orderBys, String keyField, String valueField) {
        BaseResult<DynamicObjectCollection> baseResult = this.queryCol(entityName, selectFields, filters, orderBys);
        if (baseResult.isSuccess() && !((DynamicObjectCollection)baseResult.getData()).isEmpty() && !SWCStringUtils.isEmpty((String)valueField)) {
            return BaseResult.success((Object)((DynamicObjectCollection)baseResult.getData()).stream().collect(LinkedHashMap::new, (map, data) -> map.put(data.getString(keyField), data.getString(valueField)), HashMap::putAll));
        }
        return BaseResult.success((Object)Collections.EMPTY_MAP);
    }

    @Override
    public BaseResult<Object[]> save(String entityName, DynamicObject[] dataArray) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.save(dataArray));
    }

    @Override
    public BaseResult<Integer> delete(String entityName, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return BaseResult.success((Object)helper.deleteByFilter(filters));
    }

    @Override
    public BaseResult<DynamicObject> createDynamicEntry(String entityName, DynamicObject data, String entryKey, List<Map<String, Object>> fieldMapList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DataEntityPropertyCollection properties = helper.generateEmptyEntryDynamicObject(entryKey).getDynamicObjectType().getProperties();
        DynamicObjectCollection collection = data.getDynamicObjectCollection(entryKey);
        collection.clear();
        fieldMapList.forEach(fieldMap -> {
            DynamicObject entry = helper.generateEmptyEntryDynamicObject(entryKey);
            properties.forEach(property -> {
                String propertyName = property.getName();
                if (!propertyName.contains("_id")) {
                    entry.set(propertyName, fieldMap.get(propertyName));
                }
            });
            collection.add((Object)entry);
        });
        return BaseResult.success((Object)data);
    }

    @Override
    public BaseResult<DynamicObjectCollection> createDynamicCol(String entityName, List<Map<String, Object>> fieldMapList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject dynamicObject = DynamicTransformUtils.getDynamicObjectById(entityName, 0L);
        if (dynamicObject == null) {
            return BaseResult.fail((String)"dynamicObject is null");
        }
        DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        fieldMapList.forEach(fieldMap -> {
            DynamicObject data = helper.generateEmptyEntryDynamicObject(entityName);
            properties.forEach(property -> {
                String propertyName = property.getName();
                if (!propertyName.contains("_id")) {
                    Object value = fieldMap.get(propertyName);
                    if (property instanceof BasedataProp && !(value instanceof DynamicObject)) {
                        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                        value = DynamicTransformUtils.getDynamicObjectById(baseEntityId, value);
                    }
                    data.set(propertyName, value);
                }
            });
            collection.add((Object)data);
        });
        return BaseResult.success((Object)collection);
    }

    @Override
    public BaseResult<OperationResult> hasPerm(String appId, String entityKey, String permItemId, String entityName, String opName) {
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((String)appId, (String)entityKey, (String)permItemId);
        OperationResult result = new OperationResult();
        if (hasPerm) {
            result.setSuccess(true);
        } else {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(SWCPermissionServiceHelper.getNoPermTips((String)entityName, (String)opName));
            errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
            result.addErrorInfo(errorInfo);
        }
        return BaseResult.success((Object)result);
    }
}

