/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.helper;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.swc.hcss.business.helper.ArithmeticHelper;
import kd.swc.hcss.common.entity.ExpressionDTO;
import kd.swc.hcss.common.enums.ExpTypeEnum;

public class CalculatorHelper {
    private static final Map<String, Integer> OPERATIONPRIORITY = ImmutableMap.builder().put((Object)"+", (Object)1).put((Object)"-", (Object)1).put((Object)"*", (Object)2).put((Object)"/", (Object)2).put((Object)"(", (Object)3).put((Object)")", (Object)0).build();

    public static BigDecimal infixCalculator(List<ExpressionDTO> expressionList) {
        String opPop;
        Stack<BigDecimal> numStack = new Stack<BigDecimal>();
        Stack<String> opStack = new Stack<String>();
        opStack.push(null);
        for (ExpressionDTO expression : expressionList) {
            ExpTypeEnum typeEnum = expression.getExpTypeEnum();
            String content = expression.getContent();
            if (ExpTypeEnum.ITEM == typeEnum || ExpTypeEnum.NUM == typeEnum) {
                numStack.push(new BigDecimal(content));
            }
            if (ExpTypeEnum.CHARACTER != typeEnum) continue;
            while (!"(".equals(opStack.peek()) && CalculatorHelper.getOperationPriority((String)opStack.peek(), content)) {
                String op = (String)opStack.pop();
                BigDecimal calculate = CalculatorHelper.calculate((BigDecimal)numStack.pop(), (BigDecimal)numStack.pop(), op);
                numStack.push(calculate);
                if (!opStack.isEmpty()) continue;
                break;
            }
            if (")".equals(content)) {
                if (!"(".equals(opStack.peek())) continue;
                opStack.pop();
                continue;
            }
            opStack.push(content);
        }
        while (null != (opPop = (String)opStack.pop())) {
            BigDecimal calculate = CalculatorHelper.calculate((BigDecimal)numStack.pop(), (BigDecimal)numStack.pop(), opPop);
            numStack.push(calculate);
        }
        return (BigDecimal)numStack.pop();
    }

    public static BigDecimal suffixCalculator(List<ExpressionDTO> expressionList) {
        List<ExpressionDTO> expressionSuffixList = CalculatorHelper.toSuffixExpression(expressionList);
        Stack<BigDecimal> numStack = new Stack<BigDecimal>();
        for (ExpressionDTO expression : expressionSuffixList) {
            ExpTypeEnum typeEnum = expression.getExpTypeEnum();
            String content = expression.getContent();
            if (ExpTypeEnum.CHARACTER == typeEnum) {
                BigDecimal secondValue = (BigDecimal)numStack.pop();
                BigDecimal firstValue = (BigDecimal)numStack.pop();
                BigDecimal calculate = CalculatorHelper.calculate(firstValue, secondValue, content);
                numStack.push(calculate);
                continue;
            }
            if (ExpTypeEnum.ITEM != typeEnum && ExpTypeEnum.NUM != typeEnum) continue;
            numStack.push(new BigDecimal(content));
        }
        return (BigDecimal)numStack.pop();
    }

    public static List<ExpressionDTO> toSuffixExpression(List<ExpressionDTO> expressionList) {
        ArrayList<ExpressionDTO> expressionSuffixList = new ArrayList<ExpressionDTO>(expressionList.size());
        Stack<ExpressionDTO> operator = new Stack<ExpressionDTO>();
        for (ExpressionDTO expression : expressionList) {
            ExpTypeEnum typeEnum = expression.getExpTypeEnum();
            String content = expression.getContent();
            if (ExpTypeEnum.CHARACTER == typeEnum) {
                if (operator.isEmpty()) {
                    operator.push(expression);
                    continue;
                }
                while (!"(".equals(((ExpressionDTO)operator.peek()).getContent()) && CalculatorHelper.getOperationPriority(((ExpressionDTO)operator.peek()).getContent(), content)) {
                    expressionSuffixList.add((ExpressionDTO)operator.pop());
                    if (!operator.isEmpty()) continue;
                }
                if (")".equals(content)) {
                    if (!"(".equals(((ExpressionDTO)operator.peek()).getContent())) continue;
                    operator.pop();
                    continue;
                }
                operator.push(expression);
                continue;
            }
            if (ExpTypeEnum.ITEM != typeEnum && ExpTypeEnum.NUM != typeEnum) continue;
            expressionSuffixList.add(expression);
        }
        while (!operator.isEmpty()) {
            expressionSuffixList.add((ExpressionDTO)operator.pop());
        }
        return expressionSuffixList;
    }

    private static boolean getOperationPriority(String op1, String op2) {
        return OPERATIONPRIORITY.getOrDefault(op1, 0) - OPERATIONPRIORITY.getOrDefault(op2, 0) >= 0;
    }

    private static BigDecimal calculate(BigDecimal firstValue, BigDecimal secondValue, String currentOp) {
        BigDecimal result = BigDecimal.ONE;
        switch (currentOp) {
            case "+": {
                result = ArithmeticHelper.add(firstValue, secondValue);
                break;
            }
            case "-": {
                result = ArithmeticHelper.sub(firstValue, secondValue);
                break;
            }
            case "*": {
                result = ArithmeticHelper.mul(firstValue, secondValue);
                break;
            }
            case "/": {
                result = ArithmeticHelper.div(firstValue, secondValue);
                break;
            }
        }
        return result;
    }
}

