/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.swc.hcss.common.enums.DataRoundEnum;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;

public class ExchangeConversionHelper {
    public static ExchangeRateInfo getExchangeRateInfo(Long originalCurrencyId, Long targetCurrencyId, Long exchangeRateTypeId, Date conversionDate) {
        if (targetCurrencyId.equals(originalCurrencyId)) {
            return new ExchangeRateInfo();
        }
        return ExchangeRateHelper.getExchangeRateInfo((Long)originalCurrencyId, (Long)targetCurrencyId, (Long)exchangeRateTypeId, (Date)conversionDate);
    }

    public static BigDecimal currencyConversion(Long originalCurrencyId, Long targetCurrencyId, Long exchangeRateTypeId, Date conversionDate, BigDecimal originalValue, Integer scale, RoundingMode roundingMode) {
        if (targetCurrencyId.equals(originalCurrencyId)) {
            return originalValue;
        }
        ExchangeRateInfo rateInfo = ExchangeConversionHelper.getExchangeRateInfo(originalCurrencyId, targetCurrencyId, exchangeRateTypeId, conversionDate);
        if (rateInfo == null) {
            return null;
        }
        return ExchangeConversionHelper.currencyConversion(rateInfo, originalValue, scale, roundingMode);
    }

    public static BigDecimal currencyConversion(ExchangeRateInfo rateInfo, BigDecimal originalValue, Integer scale, RoundingMode roundingMode) {
        Boolean quoteType = rateInfo.getQuoteType();
        BigDecimal rate = rateInfo.getExchangeRate();
        BigDecimal value = quoteType != false ? originalValue.divide(rate, (int)scale, roundingMode) : originalValue.multiply(rate);
        return value.setScale((int)scale, roundingMode);
    }

    public static BigDecimal currencyConversion(Long originalCurrencyId, Long targetCurrencyId, Long exchangeRateTypeId, Date conversionDate, BigDecimal originalValue, Integer scale, Long dataRoundId) {
        return ExchangeConversionHelper.currencyConversion(originalCurrencyId, targetCurrencyId, exchangeRateTypeId, conversionDate, originalValue, scale, DataRoundEnum.getRoundingModeByDataRoundId((Long)dataRoundId));
    }
}

