/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.helper;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;

public class FileHelper {
    private static final Log LOGGER = LogFactory.getLog(FileHelper.class);

    public static String getUploadFileRelativePatch(String fileName) {
        RequestContext requestContext = RequestContext.get();
        return FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)UUID.randomUUID().toString(), (String)fileName);
    }

    public static String uploadFileGetUrl(InputStream input, String fileName, String filePath) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        FileItem item = new FileItem(fileName, filePath, input);
        return fileService.upload(item);
    }

    public static Map<String, Object> getUploadAttachemntParam(String entityName, String attachKey, String name, String url, int size, Object entityId) {
        HashMap<String, Object> attach = new HashMap<String, Object>(16);
        attach.put("lastModified", System.currentTimeMillis());
        attach.put("name", name);
        String uId = UUID.randomUUID().toString();
        uId = uId.replace("-", "");
        uId = uId.length() > 30 ? uId.substring(0, 30) : uId;
        attach.put("uid", uId);
        attach.put("url", url);
        attach.put("entityNum", entityName);
        attach.put("billPkId", entityId);
        attach.put("size", size);
        attach.put("status", "success");
        attach.put("fattachmentpanel", attachKey);
        attach.put("createdate", System.currentTimeMillis());
        attach.put("creator", RequestContext.get().getUserName());
        return attach;
    }

    public static void uploadAttachemnts(String entityName, String attachKey, Object entityId, List<Map<String, Object>> attachmentDatas) {
        AttachmentServiceHelper.upload((String)entityName, (Object)entityId, (String)attachKey, attachmentDatas);
    }
}

