/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.helper;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hcss.common.common.HcssCommon;
import kd.swc.hcss.common.entity.ExpressionDTO;
import kd.swc.hcss.common.enums.ExpTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaHelper
implements HcssCommon {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^(\\d|([1-9]\\d+))(\\.\\d+)?");
    public static final Map<String, String> OPERATIONCHARACTER = ImmutableMap.builder().put((Object)"add", (Object)"+").put((Object)"sub", (Object)"-").put((Object)"mul", (Object)"*").put((Object)"divide", (Object)"/").put((Object)"leftpar", (Object)"(").put((Object)"rightpar", (Object)")").build();

    public static BaseResult<List<String>> validate(String expression) {
        ArrayList<String> errorList = new ArrayList<String>(10);
        if (!FormulaHelper.parenthesisIntegrity(expression)) {
            errorList.add(ResManager.loadKDString((String)"\u62ec\u53f7\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaHelper_1", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        if (!FormulaHelper.validateExpression(expression)) {
            errorList.add(ResManager.loadKDString((String)"\u53d6\u503c\u8868\u8fbe\u5f0f\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaHelper_0", (String)"swc-hcss-business", (Object[])new Object[0]));
        } else if (!FormulaHelper.validateOperator(expression)) {
            errorList.add(ResManager.loadKDString((String)"\u53d6\u503c\u8868\u8fbe\u5f0f\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaHelper_0", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        return BaseResult.success(errorList);
    }

    public static boolean validateExpression(String expression) {
        return !(expression = expression.replaceAll(" ", "")).contains("??");
    }

    public static boolean parenthesisIntegrity(String expression) {
        char[] expCharArray;
        int num = 0;
        for (char temp : expCharArray = expression.toCharArray()) {
            if (temp == '(') {
                ++num;
            } else if (temp == ')') {
                --num;
            }
            if (num >= 0) continue;
            return false;
        }
        return num <= 0;
    }

    public static boolean validateOperator(String expression) {
        return (expression = expression.replaceAll("\\(|\\)", "")).matches("^\\?((\\+|-|\\*|\\/)\\?)*$");
    }

    public static String transformExpression(List<ExpressionDTO> expressionList, Map<String, String> map) {
        StringBuilder expressionStr = new StringBuilder();
        for (ExpressionDTO expression : expressionList) {
            if (ExpTypeEnum.ITEM == expression.getExpTypeEnum()) {
                String field = expression.getContent();
                String id = map.get(field);
                if (!SWCStringUtils.isEmpty((String)id)) {
                    expressionStr.append('[').append(id).append(']');
                    continue;
                }
                expressionStr.append('[').append(field).append(']');
                continue;
            }
            expressionStr.append(expression.getContent());
        }
        return expressionStr.toString();
    }

    public static List<ExpressionDTO> extractMessage(String msg, char left, char right, Set<String> character) {
        int start = 0;
        int startFlag = 0;
        int endFlag = 0;
        ArrayList<ExpressionDTO> list = new ArrayList<ExpressionDTO>(10);
        int tag = 0;
        int length = msg.length();
        for (int i = 0; i < length; ++i) {
            if (msg.charAt(i) == left) {
                if (++startFlag != endFlag + 1) continue;
                start = i;
                continue;
            }
            if (msg.charAt(i) != right || ++endFlag != startFlag) continue;
            String pre = msg.substring(tag, start);
            FormulaHelper.spitStr(pre, list, character);
            String content = msg.substring(start + 1, i);
            list.add(new ExpressionDTO(ExpTypeEnum.ITEM, content));
            tag = i + 1;
        }
        if (tag < length) {
            String last = msg.substring(tag, length);
            FormulaHelper.spitStr(last, list, character);
        }
        return list;
    }

    private static void spitStr(String str, List<ExpressionDTO> list, Set<String> character) {
        int tag = 0;
        str = str.replaceAll(" ", "");
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            String charValue = String.valueOf(str.charAt(i));
            if (!character.contains(charValue)) continue;
            if (tag < i) {
                String pre = str.substring(tag, i);
                list.add(FormulaHelper.getExpressionDTO(pre));
            }
            list.add(new ExpressionDTO(ExpTypeEnum.CHARACTER, charValue));
            tag = i + 1;
        }
        if (tag < length) {
            String last = str.substring(tag, length);
            list.add(FormulaHelper.getExpressionDTO(last));
        }
    }

    private static ExpressionDTO getExpressionDTO(String str) {
        if (NUMBER_PATTERN.matcher(str).matches()) {
            return new ExpressionDTO(ExpTypeEnum.NUM, str);
        }
        return new ExpressionDTO(ExpTypeEnum.TEXT, str);
    }
}

