/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.model.income;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hcss.business.web.income.billfieldrule.EconTplControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.IBaseFieldControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.IsUploadTplControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.IssueTypeControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.PrintTplControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.ReceiveWayControlRule;
import kd.swc.hcss.business.web.income.billfieldrule.deal.LawEntityControlRule;
import kd.swc.hcss.common.common.IncomeProofCommon;

public class IncomeBillControlDTO
implements IncomeProofCommon {
    private String fieldKey;
    private Object value;
    private Boolean enable;
    private Boolean visible;
    private Boolean isMust;
    private List<IncomeBillControlDTO> associatedControls;
    private IBaseFieldControlRule controlRule;

    public IncomeBillControlDTO(String fieldKey) {
        this.fieldKey = fieldKey;
        this.visible = Boolean.TRUE;
        this.enable = Boolean.TRUE;
        this.controlRule = this.getControlRule();
    }

    public IncomeBillControlDTO(String fieldKey, Object value, Boolean enable, Boolean visible) {
        this.fieldKey = fieldKey;
        this.value = value;
        this.enable = enable;
        this.visible = visible;
    }

    public IncomeBillControlDTO(String fieldKey, Object value, Boolean enable, Boolean visible, Boolean isMust) {
        this.fieldKey = fieldKey;
        this.value = value;
        this.enable = enable;
        this.visible = visible;
        this.isMust = isMust;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean getMust() {
        return this.isMust;
    }

    public void setMust(Boolean must) {
        this.isMust = must;
    }

    public List<IncomeBillControlDTO> getAssociatedControls() {
        return this.associatedControls;
    }

    public void setAssociatedControls(List<IncomeBillControlDTO> associatedControls) {
        this.associatedControls = associatedControls;
    }

    public void addAssociatedControls(IncomeBillControlDTO associatedControlKey) {
        if (this.associatedControls == null) {
            this.associatedControls = new ArrayList<IncomeBillControlDTO>(10);
        }
        this.associatedControls.add(associatedControlKey);
    }

    public boolean dealRule(IncomeBillControlDTO changeField, DynamicObject billData) {
        IBaseFieldControlRule controlRule = this.controlRule;
        if (controlRule == null) {
            return true;
        }
        controlRule.rule(this, changeField, billData);
        Object value = this.value;
        boolean isChange = true;
        Object billValue = billData.get(this.fieldKey);
        if (value == null && billValue == null) {
            return true;
        }
        if (billValue instanceof DynamicObject && value instanceof DynamicObject) {
            isChange = !((DynamicObject)billValue).get("id").equals(((DynamicObject)value).get("id"));
        } else if (value != null) {
            boolean bl = isChange = !value.equals(billValue);
        }
        if (isChange) {
            billData.set(this.fieldKey, value);
        }
        return isChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeBillControlDTO that = (IncomeBillControlDTO)o;
        return Objects.equals(this.fieldKey, that.fieldKey);
    }

    public int hashCode() {
        return Objects.hash(this.fieldKey);
    }

    private IBaseFieldControlRule getControlRule() {
        String fieldKey = this.fieldKey;
        if ("printtpl".equals(fieldKey)) {
            return new PrintTplControlRule();
        }
        if ("isuploadtpl".equals(fieldKey)) {
            return new IsUploadTplControlRule();
        }
        if ("econtpl".equals(fieldKey)) {
            return new EconTplControlRule();
        }
        if ("issuetype".equals(fieldKey)) {
            return new IssueTypeControlRule();
        }
        if ("receiveway".equals(fieldKey)) {
            return new ReceiveWayControlRule();
        }
        if ("lawentity".equals(fieldKey)) {
            return new LawEntityControlRule();
        }
        return null;
    }
}

