/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.mq;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.util.DynamicTransformUtils;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.util.BaseResult;

public class IncomeBillActivityConsumer
implements MessageConsumer,
IncomeProofCommon {
    private static final Log LOGGER = LogFactory.getLog(IncomeBillActivityConsumer.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        DynamicObject[] billDataArray;
        LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage---start---message:{0}", message));
        Map messageMap = HRJSONUtils.convertJSONObjectToMap((Object)message);
        Long bizBillId = HRJSONUtils.getLongValOfCustomParam(messageMap.get("bizBillId"));
        Long activityInstanceId = HRJSONUtils.getLongValOfCustomParam(messageMap.get("instanceId"));
        for (DynamicObject billData : billDataArray = this.incomeProofBillService.getSaveIncomeProofBillDataByIds("billno,billstatus,auditstatus,dealstatus,activityins,isuploadtpl,ischeck", Collections.singletonList(bizBillId))) {
            billData.set("activityins", (Object)DynamicTransformUtils.getDynamicObjectById("hrcs_activityins", activityInstanceId));
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"updateTaskBindBillInfo", (Object[])new Object[]{activityInstanceId, billData.get("id"), billData.get("billno")});
        }
        try {
            BaseResult<?> baseResult = this.incomeProofBillService.operateIncomeProofBill(billDataArray, "begincheckapprove", null);
            if (!baseResult.isSuccess()) {
                LOGGER.info(MessageFormat.format("operation.onMessage---error---message:{0}", baseResult.getMessage()));
            }
        }
        catch (Exception e) {
            messageAcker.deny(messageId);
            LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage---error---exception:{0}", e));
            LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage---error---message:{0}", message));
        }
    }
}

