/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.service.income;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcss.business.dao.income.AgentIncomeProofBillDao;
import kd.swc.hcss.business.dao.income.IncomeProofBillDao;
import kd.swc.hcss.business.dao.income.IncomeProofBillIssueLogDao;
import kd.swc.hcss.business.dao.income.IncomeProofHandleDao;
import kd.swc.hcss.business.handle.orm.ActivityDataHandle;
import kd.swc.hcss.business.handle.orm.IDataHandle;
import kd.swc.hcss.business.handle.orm.PersonDataHandle;
import kd.swc.hcss.business.helper.CueHelper;
import kd.swc.hcss.business.helper.FileHelper;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.model.income.IncomeBillIssueTypeDTO;
import kd.swc.hcss.business.model.income.IncomeDealCalResultDTO;
import kd.swc.hcss.business.mservice.econtract.IEcontractService;
import kd.swc.hcss.business.mservice.person.IStrategyService;
import kd.swc.hcss.business.mservice.salarymamager.ISalaryManagerService;
import kd.swc.hcss.business.service.AbstractHcssService;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.service.income.RevenueFieldService;
import kd.swc.hcss.business.util.DaoFactory;
import kd.swc.hcss.business.web.income.billop.AbandonOperation;
import kd.swc.hcss.business.web.income.billop.AutoCalOperation;
import kd.swc.hcss.business.web.income.billop.AutoSignOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BeginCheckApproveOperation;
import kd.swc.hcss.business.web.income.billop.CheckApproveOperation;
import kd.swc.hcss.business.web.income.billop.ClaimedOperation;
import kd.swc.hcss.business.web.income.billop.DownCustomAttOperation;
import kd.swc.hcss.business.web.income.billop.FirmCommitOperation;
import kd.swc.hcss.business.web.income.billop.IssueOperation;
import kd.swc.hcss.business.web.income.billop.ReSignOperation;
import kd.swc.hcss.business.web.income.billop.ReceivedDealOperation;
import kd.swc.hcss.business.web.income.billop.ReceivedOperation;
import kd.swc.hcss.business.web.income.billop.SaveDealOperation;
import kd.swc.hcss.business.web.income.billop.SaveOperation;
import kd.swc.hcss.business.web.income.billop.SignBackOperation;
import kd.swc.hcss.business.web.income.billop.StatusOperation;
import kd.swc.hcss.business.web.income.billop.SubmitOperation;
import kd.swc.hcss.business.web.income.billop.UnSubmitOperation;
import kd.swc.hcss.business.web.income.billop.ViewFlowChartOperation;
import kd.swc.hcss.business.web.income.billop.ViewIssueLogOperation;
import kd.swc.hcss.common.common.IncomeProofCommon;
import kd.swc.hcss.common.entity.ExchangeRateDetailDTO;
import kd.swc.hcss.common.entity.RevenueFieldCalResult;
import kd.swc.hcss.common.enums.HandleTypeEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@HrDomainEntity
public class IncomeProofBillService
extends AbstractHcssService
implements IncomeProofCommon {
    private static final Log LOGGER = LogFactory.getLog(IncomeProofBillService.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private IncomeProofBillDao incomeProofBillDao = DaoFactory.getDao(IncomeProofBillDao.class);
    private AgentIncomeProofBillDao agentIncomeProofBillDao = DaoFactory.getDao(AgentIncomeProofBillDao.class);
    private IncomeProofHandleDao incomeProofBillHandleDao = DaoFactory.getDao(IncomeProofHandleDao.class);
    private IncomeProofBillIssueLogDao incomeProofBillIssueLogDao = DaoFactory.getDao(IncomeProofBillIssueLogDao.class);
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);
    private RevenueFieldService revenueFieldService = (RevenueFieldService)DomainFactory.getInstance(RevenueFieldService.class);
    private static final Map<String[], List<String>> BUTTON_MAP = ImmutableMap.builder().put((Object)new String[]{"A", null, null}, Arrays.asList("save", "bar_viewflowchart")).put((Object)new String[]{"B", null, null}, Arrays.asList("modify", "firmcommit", "bar_viewflowchart")).put((Object)new String[]{"C", null, null}, Collections.singletonList("bar_viewflowchart")).put((Object)new String[]{"I", "false", "0"}, Collections.singletonList("issued")).put((Object)new String[]{"I", "false", "1"}, Collections.singletonList("resign")).put((Object)new String[]{"I", "true", null}, Collections.singletonList("receiveddeal")).put((Object)new String[]{"K", "false", "0"}, Arrays.asList("issued", "claimed")).put((Object)new String[]{"K", "false", "1"}, Collections.singletonList("claimed")).put((Object)new String[]{"K", "true", null}, Collections.singletonList("claimed")).put((Object)new String[]{"S", null, null}, Collections.emptyList()).put((Object)new String[]{"F", null, null}, Collections.singletonList("resign")).build();

    public MutableGraph<IncomeBillControlDTO> getFieldControlGraph() {
        MutableGraph graph = GraphBuilder.directed().build();
        IncomeBillControlDTO applyReason = new IncomeBillControlDTO("applyreason");
        IncomeBillControlDTO isUploadTpl = new IncomeBillControlDTO("isuploadtpl");
        IncomeBillControlDTO printTpl = new IncomeBillControlDTO("printtpl");
        IncomeBillControlDTO econTpl = new IncomeBillControlDTO("econtpl");
        IncomeBillControlDTO issueType = new IncomeBillControlDTO("issuetype");
        IncomeBillControlDTO receiveWay = new IncomeBillControlDTO("receiveway");
        graph.putEdge((Object)applyReason, (Object)printTpl);
        graph.putEdge((Object)applyReason, (Object)isUploadTpl);
        graph.putEdge((Object)printTpl, (Object)econTpl);
        graph.putEdge((Object)isUploadTpl, (Object)printTpl);
        graph.putEdge((Object)isUploadTpl, (Object)issueType);
        graph.putEdge((Object)econTpl, (Object)issueType);
        graph.putEdge((Object)issueType, (Object)receiveWay);
        return graph;
    }

    public MutableGraph<IncomeBillControlDTO> getDealFieldControlGraph() {
        IncomeBillControlDTO lawEntity = new IncomeBillControlDTO("lawentity");
        MutableGraph<IncomeBillControlDTO> graph = this.getFieldControlGraph();
        graph.addNode((Object)lawEntity);
        return graph;
    }

    public void fieldInitData(IncomeBillControlDTO changeField, DynamicObject billData, MutableGraph<IncomeBillControlDTO> graph, Map<String, IncomeBillControlDTO> resultMap) {
        Set successors;
        String fieldKey = changeField.getFieldKey();
        changeField.setValue(billData.get(fieldKey));
        if (!resultMap.containsKey(fieldKey)) {
            changeField.dealRule(changeField, billData);
            resultMap.put(fieldKey, changeField);
            List<IncomeBillControlDTO> associatedControls = changeField.getAssociatedControls();
            if (associatedControls != null) {
                associatedControls.forEach(data -> resultMap.put(data.getFieldKey(), (IncomeBillControlDTO)data));
            }
        }
        if ((successors = graph.successors((Object)changeField)) == null) {
            return;
        }
        for (IncomeBillControlDTO controlDTO : successors) {
            this.fieldInitData(controlDTO, billData, graph, resultMap);
        }
    }

    public void fieldPropertyChanged(IncomeBillControlDTO changeField, DynamicObject billData, MutableGraph<IncomeBillControlDTO> graph, Map<String, IncomeBillControlDTO> resultMap) {
        Set successors = graph.successors((Object)changeField);
        if (successors == null) {
            return;
        }
        changeField.dealRule(changeField, billData);
        for (IncomeBillControlDTO controlDTO : successors) {
            controlDTO.setValue(billData.get(controlDTO.getFieldKey()));
            boolean isChange = controlDTO.dealRule(changeField, billData);
            resultMap.put(controlDTO.getFieldKey(), controlDTO);
            List<IncomeBillControlDTO> associatedControls = controlDTO.getAssociatedControls();
            if (associatedControls != null) {
                associatedControls.forEach(data -> resultMap.put(data.getFieldKey(), (IncomeBillControlDTO)data));
            }
            if (!isChange) continue;
            this.fieldPropertyChanged(controlDTO, billData, graph, resultMap);
        }
        List<IncomeBillControlDTO> associatedControls = changeField.getAssociatedControls();
        if (associatedControls != null) {
            associatedControls.forEach(data -> resultMap.put(data.getFieldKey(), (IncomeBillControlDTO)data));
        }
    }

    public Map<String, Object> getCurPersonInfo() {
        BaseResult<Map<String, Object>> baseResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getPersonInfo();
        if (!baseResult.isSuccess()) {
            return Collections.EMPTY_MAP;
        }
        return (Map)baseResult.getData();
    }

    public Map<String, Object> getPersonInfoMap(Long personId) {
        Map<String, Object> dataMap = this.getPersonPrimaryEmpposorgrel(personId);
        Long employeeId = MapUtils.getLong(dataMap, (Object)"employee_id");
        Map<String, Object> personContact = this.getPersonContact(personId);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("company", dataMap.get("company_id"));
        map.put("adminorg", dataMap.get("adminorg_id"));
        map.put("job", dataMap.get("job_id"));
        map.put("position", dataMap.get("position_id"));
        map.put("employee", employeeId);
        map.put("person", personId);
        map.put("percontact", personContact.get("id"));
        Map<String, Object> laborRelRecord = this.getLaborRelRecord(employeeId);
        map.put("lawentity", laborRelRecord.get("lawentity_id"));
        return map;
    }

    public BaseResult<?> operateIncomeProofBill(DynamicObject[] billDataArray, String operationKey, Map<String, String> variableValues) {
        return this.decorator(operationKey).operation(billDataArray, operationKey, variableValues);
    }

    public void saveOrUpdateIncomeBillData(DynamicObject[] billDataArray) {
        if (billDataArray == null || billDataArray.length == 0) {
            return;
        }
        String name = billDataArray[0].getDataEntityType().getName();
        if ("hcss_incomeproofbill".equals(name)) {
            this.incomeProofBillDao.saveOrUpdateData(billDataArray);
        } else if ("hcss_agentincomeproofbill".equals(name)) {
            this.agentIncomeProofBillDao.saveOrUpdateData(billDataArray);
        } else if ("hcss_incomeproofhandle".equals(name)) {
            this.incomeProofBillHandleDao.saveOrUpdateData(billDataArray);
        }
    }

    public boolean isExistIncomeProofBillByFilter(QFilter filter) {
        List<QFilter> dataRuleViewFilter = this.getIncomeProofHandleDataRuleViewFilter("hcss_incomeproofbill");
        dataRuleViewFilter.add(filter);
        return this.incomeProofBillDao.existIncomeProofBill(dataRuleViewFilter.toArray(new QFilter[0]));
    }

    public void setIncomeProofBillIncomeInfoEntry(DynamicObject data, List<Map<String, Object>> mapList) {
        this.getDataHandle(HandleTypeEnum.DATAHANDLE).createDynamicEntry("hcss_incomeproofhandle", data, "entryentity", mapList);
    }

    public void saveIncomeProofBillIssuedLog(DynamicObject[] billDataArray) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        long[] ids = dataHandle.getIds("hcss_issueprooflog", billDataArray.length);
        int index = 0;
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject billData : billDataArray) {
            Long billId = billData.getLong("id");
            DynamicObject logData = dataHandle.getEmptyDynamicObject("hcss_issueprooflog");
            logData.set("id", (Object)ids[index++]);
            logData.set("incomeproofbill", (Object)billId);
            logData.set("creator", (Object)RequestContext.get().getCurrUserId());
            logData.set("createtime", (Object)new Date());
            int num = billData.getInt("printnum") + 1;
            logData.set("issuenum", (Object)num);
            billData.set("printnum", (Object)num);
            collection.add((Object)logData);
        }
        this.incomeProofBillIssueLogDao.saveOrUpdateData((DynamicObject[])collection.toArray((Object[])new DynamicObject[0]));
    }

    public List<Long> getHavePermBillIds(List<Long> billIds, String permissionId) {
        List<QFilter> dataRuleFilter = this.getIncomeProofHandleDataRuleFilter(permissionId);
        QFilter filter = new QFilter("id", "in", billIds);
        dataRuleFilter.add(filter);
        DynamicObjectCollection col = this.incomeProofBillHandleDao.queryDataCol("id", dataRuleFilter.toArray(new QFilter[0]));
        return col.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getHavePermBillIds(String appId, List<Long> billIds, String permissionId) {
        List<QFilter> dataRuleFilter = this.getIncomeProofHandleDataRuleFilter(appId, permissionId);
        QFilter filter = new QFilter("id", "in", billIds);
        dataRuleFilter.add(filter);
        DynamicObjectCollection col = this.incomeProofBillHandleDao.queryDataCol("id", dataRuleFilter.toArray(new QFilter[0]));
        return col.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getHaveIssuedLogBillIds(List<Long> billIds) {
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(new QFilter("printnum", ">", (Object)0));
        DynamicObjectCollection col = this.incomeProofBillHandleDao.queryDataCol("id", new QFilter[]{filter});
        return col.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
    }

    public Long getBillIdByIssueLogId(Long issueLogId) {
        QFilter filter = new QFilter("id", "=", (Object)issueLogId);
        DynamicObject issuedLog = this.incomeProofBillIssueLogDao.queryOneData("incomeproofbill.id", new QFilter[]{filter});
        if (issuedLog == null) {
            return 0L;
        }
        return issuedLog.getLong("incomeproofbill.id");
    }

    public String previewIncomeProofBillPdf(Long billId, String printTplId) {
        PrtAttach prtAttach = this.doIncomeProofBillPdf(Collections.singletonList(billId), printTplId);
        String openUrlTpl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
        String openUrl = "";
        for (PrtAttach.AttachDetail attachDetail : prtAttach.getAttachDetail()) {
            openUrl = String.format(openUrlTpl, prtAttach.getTaskId(), attachDetail.getAttachId());
        }
        return openUrl;
    }

    public PrtAttach doIncomeProofBillPdf(List<Object> billIds, String printTplId) {
        PrintWork work = new PrintWork();
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        work.add(task);
        task.setFormId("hcss_incomeproofhandle");
        task.setTplId(printTplId);
        task.setPrintType("billForm");
        task.setPkIds(billIds);
        return BosPrintServiceHelper.execPrint((PrintWork)work);
    }

    public String getPreviewIncomeProofBillPdfTaskId() {
        return String.valueOf(this.getDataHandle(HandleTypeEnum.DATAHANDLE).getId("t_svc_printresult"));
    }

    public List<PrtTaskResult.Attach> getPreviewIncomeProofBillPdfAttachList(String taskId, Map<String, List<Object>> printBillMap, String parentPageId) {
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        printBillMap.forEach((printId, billIds) -> {
            PrintTask printTasks = this.getPrintTasks((String)printId, (List<Object>)billIds, parentPageId);
            taskList.add(printTasks);
        });
        try {
            this.doNewPreview(taskId, taskList, parentPageId);
            PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
            return taskResult.getAttach();
        }
        catch (Exception e) {
            LOGGER.info("PreviewIncomeProofBill error :{}", (Object)e.getMessage());
            return null;
        }
    }

    public List<Map<String, Object>> getDealAttachmentData(Long billId) {
        return AttachmentServiceHelper.getAttachments((String)"hcss_incomeproofhandle", (Object)billId, (String)"attachmentpanel");
    }

    public Map<String, Object> getPreviewPrintTpl(String printTplId, String printTplName) {
        String url = this.previewIncomeProofBillPdf(0L, printTplId);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("fileExt", "pdf");
        map.put("fileId", UUID.randomUUID().toString());
        map.put("fileName", printTplName);
        map.put("fileTime", System.currentTimeMillis());
        map.put("filesource", "1");
        map.put("previewType", "0");
        map.put("previewUrl", url);
        return map;
    }

    public String getBillNameByDataSource(String dataSource) {
        if ("1".equals(dataSource)) {
            return "hcss_incomeproofbill";
        }
        return "hcss_agentincomeproofbill";
    }

    public List<Map<String, Object>> getAttachmentData(String formId, Long billId) {
        return AttachmentServiceHelper.getAttachments((String)formId, (Object)billId, (String)"attachmentpanel");
    }

    public void recycleIncomeProofBillNumber(String number) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        DynamicObject billData = dataHandle.getEmptyDynamicObject("hcss_incomeproofbill");
        dataHandle.recycleNumber("hcss_incomeproofbill", billData, null, number);
    }

    public OperationResult hasPerm(String permItemId, String opName) {
        return (OperationResult)this.getDataHandle(HandleTypeEnum.DATAHANDLE).hasPerm("33EUPRZ1Q202", "hcss_incomeproofhandle", permItemId, ResManager.loadKDString((String)"\u6536\u5165\u8bc1\u660e\u529e\u7406", (String)"IncomeProofBillService_0", (String)"swc-hcss-business", (Object[])new Object[0]), opName).getData();
    }

    public OperationResult hasPerm(String appId, String permItemId, String opName) {
        return (OperationResult)this.getDataHandle(HandleTypeEnum.DATAHANDLE).hasPerm(appId, "hcss_incomeproofhandle", permItemId, ResManager.loadKDString((String)"\u6536\u5165\u8bc1\u660e\u529e\u7406", (String)"IncomeProofBillService_0", (String)"swc-hcss-business", (Object[])new Object[0]), opName).getData();
    }

    public OperationResult hasViewPerm() {
        return (OperationResult)this.getDataHandle(HandleTypeEnum.DATAHANDLE).hasPerm("33EUPRZ1Q202", "hcss_incomeproofhandle", "47150e89000000ac", ResManager.loadKDString((String)"\u6536\u5165\u8bc1\u660e\u529e\u7406", (String)"IncomeProofBillService_0", (String)"swc-hcss-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2", (String)"IncomeProofBillService_3", (String)"swc-hcss-business", (Object[])new Object[0])).getData();
    }

    public List<QFilter> getIncomeProofHandleDataRuleFilter(String permissionId) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        List<QFilter> dataRuleFilter = dataHandle.getAuthorizedDataRuleFilterViewPerm("hcss_incomeproofhandle");
        Tuple<Boolean, List<Long>> tuple = dataHandle.getPermOrgList("hcss_incomeproofhandle", permissionId);
        if (!((Boolean)tuple.item1).booleanValue()) {
            dataRuleFilter.add(new QFilter("org", "in", tuple.item2));
        }
        return dataRuleFilter;
    }

    public List<QFilter> getIncomeProofHandleDataRuleFilter(String appId, String permissionId) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        List<QFilter> dataRuleFilter = dataHandle.getAuthorizedDataRuleFilterViewPerm(appId, "hcss_incomeproofhandle");
        Tuple<Boolean, List<Long>> tuple = dataHandle.getPermOrgList(appId, "hcss_incomeproofhandle", permissionId);
        if (!((Boolean)tuple.item1).booleanValue()) {
            dataRuleFilter.add(new QFilter("org", "in", tuple.item2));
        }
        return dataRuleFilter;
    }

    public List<QFilter> getIncomeProofHandleDataRuleViewFilter(String entityName) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        List<QFilter> dataRuleFilter = dataHandle.getAuthorizedDataRuleFilterViewPerm(entityName);
        Tuple<Boolean, List<Long>> tuple = dataHandle.getPermOrgList(entityName, "47150e89000000ac");
        if (!((Boolean)tuple.item1).booleanValue()) {
            dataRuleFilter.add(new QFilter("org", "in", tuple.item2));
        }
        return dataRuleFilter;
    }

    public Tuple<Boolean, List<Long>> getIncomeProofHandleDataPermOrgList(String entityName, String permItemId) {
        IDataHandle dataHandle = this.getDataHandle(HandleTypeEnum.DATAHANDLE);
        return dataHandle.getPermOrgList(entityName, permItemId);
    }

    public List<Long> getIncomeProofBillIdListByFilter() {
        DynamicObjectCollection billCol = this.incomeProofBillHandleDao.queryDataCol("id", this.getIncomeProofHandleDataRuleViewFilter("hcss_incomeproofhandle").toArray(new QFilter[0]));
        return billCol.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject[] getSaveIncomeProofBillDataByIds(String selectFields, List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return this.incomeProofBillDao.getSaveData(selectFields, new QFilter[]{filter});
    }

    public DynamicObject getSaveIncomeProofBillDataById(String selectFields, Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return this.incomeProofBillDao.getSaveOneData(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryIncomeProofBillCol(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return this.incomeProofBillHandleDao.getSaveData("id,billno,person.id,dealstatus,printtpl", new QFilter[]{filter});
    }

    public DynamicObject queryIncomeProofBill(String selectFields, Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return this.incomeProofBillHandleDao.queryOneData(selectFields, new QFilter[]{filter});
    }

    public DynamicObjectCollection queryIncomeProofBillHandleCol(String selectFields, QFilter filter, String orderBys) {
        return this.incomeProofBillHandleDao.queryDataCol(selectFields, new QFilter[]{filter}, orderBys);
    }

    public DynamicObjectCollection getRevenueFieldCol(String printTplId) {
        if (SWCStringUtils.isEmpty((String)printTplId)) {
            return new DynamicObjectCollection();
        }
        PrintTplService tplService = new PrintTplService();
        PrintMetadata metadata = tplService.getMetadata(printTplId);
        List pages = metadata.getPages();
        Set revenueFieldSet = null;
        if (!pages.isEmpty()) {
            revenueFieldSet = pages.stream().flatMap(Collection::stream).filter(data -> "salaryfields".equals(((Text)data).getDataSource())).map(data -> ((Text)data).getBindField()).collect(Collectors.toSet());
        }
        if (revenueFieldSet == null || revenueFieldSet.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("number", "in", (Object)revenueFieldSet);
        return this.revenueFieldService.queryRevenueFieldCol(new QFilter[]{filter}, "number asc");
    }

    public Map<String, String> getPrintRevenueFieldMap(Long billId) {
        QFilter filter = new QFilter("id", "=", (Object)billId);
        return this.incomeProofBillHandleDao.queryRevenueFieldValueMap(new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult consentBillActivity(DynamicObject billData, String msg) {
        try (TXHandle handle = TX.notSupported();){
            List<Long> activityIdList = Collections.singletonList(billData.getLong("activityins.id"));
            BaseResult<OperationResult> baseResult = ((ActivityDataHandle)this.getDataHandle(HandleTypeEnum.ACTIVITY_DATAHANDLE)).consentBillActivityNode(activityIdList, SWCStringUtils.isEmpty((String)msg) ? ResManager.loadKDString((String)"\u5df2\u6838\u5b9a\u6536\u5165", (String)"IncomeProofBillService_2", (String)"swc-hcss-business", (Object[])new Object[0]) : msg);
            LOGGER.info("consentBillActivity OperationResult : {}", (Object)JSON.toJSONString(baseResult));
            OperationResult operationResult = (OperationResult)baseResult.getData();
            return operationResult;
        }
    }

    public OperationResult invokeOperation(DynamicObject[] billDataArray, String opName) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        return opImpl.localInvokeOperation(opName, billDataArray, operateOption);
    }

    public int getBillStatusNum(List<String> dealStatusList) {
        return this.incomeProofBillHandleDao.queryIncomeProofHandleNum(this.getStatusFilter(dealStatusList, "47150e89000000ac").toArray(new QFilter[0]));
    }

    public BaseOperation decorator(String operationKey) {
        BaseOperation operation = new StatusOperation();
        switch (operationKey) {
            case "save": {
                operation = new SaveOperation(operation);
                break;
            }
            case "submit": {
                operation = new SubmitOperation(operation);
                break;
            }
            case "abandonmob": 
            case "abandoned": {
                operation = new AbandonOperation(operation);
                break;
            }
            case "begincheckapprove": {
                operation = new BeginCheckApproveOperation(operation);
                break;
            }
            case "checkapprove": {
                operation = new CheckApproveOperation(operation);
                break;
            }
            case "saveincomeinfo": {
                operation = new SaveDealOperation(operation);
                break;
            }
            case "firmcommit": {
                operation = new FirmCommitOperation(operation);
                break;
            }
            case "autocal": {
                operation = new AutoCalOperation(operation);
                break;
            }
            case "issued": {
                operation = new IssueOperation(operation);
                break;
            }
            case "claimed": {
                operation = new ClaimedOperation(operation);
                break;
            }
            case "received": {
                operation = new ReceivedOperation(operation);
                break;
            }
            case "receiveddeal": {
                operation = new ReceivedDealOperation(operation);
                break;
            }
            case "viewissuelog": {
                operation = new ViewIssueLogOperation(operation);
                break;
            }
            case "viewflowchart": {
                operation = new ViewFlowChartOperation(operation);
                break;
            }
            case "downcustomatt": {
                operation = new DownCustomAttOperation(operation);
                break;
            }
            case "resign": {
                operation = new ReSignOperation(operation);
                break;
            }
            case "autosign": {
                operation = new AutoSignOperation(operation);
                break;
            }
            case "signsuccess": {
                operation = new SignBackOperation(operation);
                break;
            }
            case "unsubmit": {
                operation = new UnSubmitOperation(operation);
                break;
            }
        }
        return operation;
    }

    public List<IncomeBillIssueTypeDTO> getIncomeBillMobileIssueType(IncomeBillControlDTO fieldControl) {
        String issueLabNotSelectType;
        String issueLabSelectType;
        String fieldKey = fieldControl.getFieldKey();
        if (!"issuetype".equals(fieldKey)) {
            return new ArrayList<IncomeBillIssueTypeDTO>(10);
        }
        String issueType = (String)fieldControl.getValue();
        Boolean enable = fieldControl.getEnable();
        ArrayList<IncomeBillIssueTypeDTO> issueTypeList = new ArrayList<IncomeBillIssueTypeDTO>(10);
        if (SWCStringUtils.isEmpty((String)issueType)) {
            issueTypeList.add(IncomeBillIssueTypeDTO.getNotSelectInstance("labelpage", Boolean.FALSE));
            issueTypeList.add(IncomeBillIssueTypeDTO.getNotSelectInstance("labelelec", Boolean.FALSE));
            return issueTypeList;
        }
        if ("0".equals(issueType)) {
            issueLabSelectType = "labelpage";
            issueLabNotSelectType = "labelelec";
        } else {
            issueLabSelectType = "labelelec";
            issueLabNotSelectType = "labelpage";
        }
        issueTypeList.add(IncomeBillIssueTypeDTO.getSelectInstance(issueLabSelectType));
        issueTypeList.add(IncomeBillIssueTypeDTO.getNotSelectInstance(issueLabNotSelectType, enable));
        return issueTypeList;
    }

    public BaseResult<SignRespParam> encontractSign(DynamicObject billData, Long lawEntityId, boolean autoSign) {
        ArrayList<String> errors = new ArrayList<String>(10);
        if (lawEntityId == null || lawEntityId == 0L) {
            errors.add(ResManager.loadKDString((String)"\u8bc1\u660e\u5f00\u5177\u5355\u4f4d", (String)"IncomeProofBillService_5", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        DynamicObject printTpl = billData.getDynamicObject("printtpl");
        String printTplId = "";
        String printTplName = "";
        if (printTpl == null) {
            errors.add(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f", (String)"IncomeProofBillService_6", (String)"swc-hcss-business", (Object[])new Object[0]));
        } else {
            printTplId = printTpl.getString("id");
            printTplName = printTpl.getString("name");
        }
        DynamicObject econTpl = billData.getDynamicObject("econtpl");
        Long econTplId = 0L;
        if (econTpl == null) {
            errors.add(ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e", (String)"IncomeProofBillService_7", (String)"swc-hcss-business", (Object[])new Object[0]));
        } else {
            econTplId = econTpl.getLong("id");
        }
        if (!errors.isEmpty()) {
            String message = CueHelper.splicingCue(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\u3002", (String)"IncomeProofBillService_8", (String)"swc-hcss-business", (Object[])new Object[0]), errors);
            return BaseResult.fail((String)message);
        }
        String filePath = this.getIncomeProofBillPdfFilePath(billData.getLong("id"), printTplId);
        SignReqParam reqParam = new SignReqParam(Long.valueOf(0L), lawEntityId);
        reqParam.setTemplateId(econTplId);
        reqParam.setFileName(printTplName);
        reqParam.setFilePath(filePath);
        reqParam.setAutoSign(autoSign);
        reqParam.setAppNum("hcss");
        reqParam.setCloud("swc");
        Throwable throwable = null;
        try (TXHandle txh = TX.requiresNew();){
            IEcontractService instance = IEcontractService.getInstance();
            BaseResult<SignRespParam> baseResult = instance.toSign(reqParam);
            return baseResult;
        }
        catch (Exception error) {
            txh.markRollback();
            BaseResult baseResult = BaseResult.fail((String)error.getMessage());
            return baseResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public BaseResult<SignRespParam> signNew(DynamicObject billData, Long lawEntityId) {
        SignReqParam reqParam = new SignReqParam(Long.valueOf(0L), lawEntityId);
        reqParam.setTemplateId(Long.valueOf(billData.getLong("econtpl.id")));
        Throwable throwable = null;
        try (TXHandle txh = TX.requiresNew();){
            IEcontractService instance = IEcontractService.getInstance();
            BaseResult<SignRespParam> baseResult = instance.signNew(reqParam, billData.getString("econnumber"));
            return baseResult;
        }
        catch (Exception error) {
            txh.markRollback();
            BaseResult baseResult = BaseResult.fail((String)error.getMessage());
            return baseResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public void encontractSignNotify(String contractNo, boolean isSuccess) {
        QFilter filter = new QFilter("econnumber", "=", (Object)contractNo);
        DynamicObject billHandle = this.incomeProofBillHandleDao.getSaveOneData("econtpl,lawentity,printtpl,person,econnumber,econtfailreason,billstatus,auditstatus,dealstatus", new QFilter[]{filter});
        if (billHandle == null) {
            return;
        }
        HashMap<String, String> variableValues = new HashMap<String, String>(16);
        variableValues.put("issignsuccess", isSuccess ? "1" : "");
        this.operateIncomeProofBill(new DynamicObject[]{billHandle}, "signsuccess", variableValues);
    }

    public BaseResult<SignRespParam> dealSign(DynamicObject billHandle) {
        SignReqParam reqParam;
        IEcontractService instance = IEcontractService.getInstance();
        BaseResult<SignRespParam> baseResult = instance.getPrevAndDownNew(reqParam = new SignReqParam(Long.valueOf(0L), Long.valueOf(billHandle.getLong("lawentity.id"))), billHandle.getString("econnumber"));
        if (baseResult.isSuccess()) {
            this.setAttachemnts(billHandle, (SignRespParam)baseResult.getData());
        }
        return baseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttachemnts(DynamicObject billData, SignRespParam respParam) {
        ArrayList<Map<String, Object>> attachmentData = new ArrayList<Map<String, Object>>(10);
        ContractView sealInfo = respParam.getSealInfo();
        if (sealInfo == null) {
            LOGGER.info("sealInfo is null");
            return;
        }
        URL fileUrl = null;
        InputStream inputStream = null;
        int fileSize = 0;
        try {
            fileUrl = new URL(sealInfo.getDownloadUrl());
            URLConnection connection = fileUrl.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(5000);
            fileSize = connection.getContentLength();
            inputStream = connection.getInputStream();
        }
        catch (Exception exception) {
            LOGGER.info("get url error {}", (Object)exception.getMessage());
            return;
        }
        Long billDataId = billData.getLong("id");
        try {
            String name = billData.getString("printtpl.name") + "-" + billData.getString("person.name");
            String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s-\u5df2\u7b7e\u7f72.pdf", (String)"IncomeProofBillService_9", (String)"swc-hcss-business", (Object[])new Object[0]), name);
            String patch = FileHelper.getUploadFileRelativePatch(fileName);
            String url = FileHelper.uploadFileGetUrl(inputStream, fileName, patch);
            Map<String, Object> attachemntParam = FileHelper.getUploadAttachemntParam("hcss_incomeproofhandle", "attachmentpanel", fileName, url, fileSize, billDataId);
            attachmentData.add(attachemntParam);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    LOGGER.info("get file error {}", (Object)exception.getMessage());
                }
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            FileHelper.uploadAttachemnts("hcss_incomeproofhandle", "attachmentpanel", billDataId, attachmentData);
        }
    }

    public Map<String, Object> getLaborRelRecord(Long employeeId) {
        BaseResult<List<Map<String, Object>>> baseResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getListEmployeeAttachs(employeeId, "hrpi_laborrelrecord");
        if (!baseResult.isSuccess()) {
            return Collections.EMPTY_MAP;
        }
        return (Map)((List)baseResult.getData()).get(0);
    }

    public Map<String, Object> getPersonContact(Long personId) {
        BaseResult<List<Map<String, Object>>> baseResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getListPersonAttachs(personId, "hrpi_percontact");
        if (!baseResult.isSuccess()) {
            return Collections.EMPTY_MAP;
        }
        return (Map)((List)baseResult.getData()).get(0);
    }

    public List<Map<String, Object>> getListBatchPersonContact(List<Long> personIds) {
        BaseResult<List<Map<String, Object>>> baseResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getListBatchPersonAttachs(personIds, "hrpi_percontact");
        if (!baseResult.isSuccess()) {
            return Collections.EMPTY_LIST;
        }
        return (List)baseResult.getData();
    }

    public IncomeDealCalResultDTO calIncomeInfo(DynamicObject dataDeal, DynamicObjectCollection revenueFieldCol, Date exrateDate) {
        String printTplId = dataDeal.getString("printtpl.id");
        if (SWCStringUtils.isEmpty((String)printTplId)) {
            return null;
        }
        Long employeeId = dataDeal.getLong("employee.id");
        LinkedHashMap<Long, List<String>> resultMap = new LinkedHashMap<Long, List<String>>(16);
        LinkedHashMap<Long, Map<Long, ExchangeRateDetailDTO>> revenueFieldRateMap = new LinkedHashMap<Long, Map<Long, ExchangeRateDetailDTO>>(16);
        HashMap<Long, Set<String>> errorMap = new HashMap<Long, Set<String>>(16);
        for (DynamicObject revenueField : revenueFieldCol) {
            BaseResult<List<RevenueFieldCalResult>> baseResult = this.cal(revenueField, exrateDate, employeeId, dataDeal.getLong("id"));
            Long fieldId = revenueField.getLong("id");
            List baseResultData = (List)baseResult.getData();
            if (baseResultData != null) {
                resultMap.put(fieldId, baseResultData.stream().map(RevenueFieldCalResult::getShowValue).collect(Collectors.toList()));
                baseResultData.forEach(calResult -> calResult.getRateInfoMap().forEach((key, value) -> {
                    Map detailMap = revenueFieldRateMap.getOrDefault(fieldId, new LinkedHashMap(16));
                    detailMap.put(key, value);
                    revenueFieldRateMap.put(fieldId, detailMap);
                }));
            }
            if (baseResult.isSuccess()) continue;
            errorMap.put(fieldId, (Set<String>)JSON.parseObject((String)baseResult.getMessage(), Set.class));
        }
        return new IncomeDealCalResultDTO(resultMap, revenueFieldRateMap, errorMap);
    }

    private BaseResult<List<RevenueFieldCalResult>> cal(DynamicObject revenueField, Date exrateDate, Long employeeId, Long billId) {
        HashMap<String, Object> editMap = new HashMap<String, Object>(16);
        if ("1".equals(revenueField.getString("exratedate"))) {
            editMap.put("exratedate", exrateDate);
        } else {
            editMap.put("exratedate", new Date());
        }
        editMap.put("employee", employeeId);
        editMap.put("billId", billId);
        Map<String, Object> param = this.revenueFieldService.getRevenueFieldCalMap(revenueField, editMap);
        return this.revenueFieldService.calRevenueField(param);
    }

    private Map<String, Object> getPersonPrimaryEmpposorgrel(Long personId) {
        BaseResult<Map<String, Object>> baseResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getPersonPrimaryEmpposorgrel(personId);
        if (!baseResult.isSuccess()) {
            return Collections.EMPTY_MAP;
        }
        return (Map)baseResult.getData();
    }

    public Long getPersonFileOrgId(Long personId) {
        if (personId == 0L) {
            return 0L;
        }
        BaseResult<DynamicObject> baseResult = ISalaryManagerService.getInstance().getAdjFileInfo("org.id", personId);
        if (!baseResult.isSuccess()) {
            BaseResult<Map<String, Object>> primaryResult = ((PersonDataHandle)this.getDataHandle(HandleTypeEnum.PERSON_HANDLE)).getPersonPrimaryEmpposorgrel(personId);
            Long adminOrgId = (Long)((Map)primaryResult.getData()).get("adminorg_id");
            BaseResult<Map<String, Object>> empStrategyResult = IStrategyService.getInstance().getHrBuFromManageEmpStrategy(adminOrgId, personId, 1050L, 0L);
            if (empStrategyResult.isSuccess()) {
                return ((DynamicObject)((Map)empStrategyResult.getData()).get("hrbu")).getLong("id");
            }
            return 0L;
        }
        return ((DynamicObject)baseResult.getData()).getLong("org.id");
    }

    private List<QFilter> getStatusFilter(List<String> dealStatusList, String permissionId) {
        List<QFilter> dataRuleFilter = this.getIncomeProofHandleDataRuleFilter(permissionId);
        dataRuleFilter.add(new QFilter("dealstatus", "in", dealStatusList));
        return dataRuleFilter;
    }

    public Map<String, List<String>> showHideButtons(String[] btnArray) {
        HashMap<String, List<String>> buttonsMap = new HashMap<String, List<String>>(16);
        ArrayList showButtons = new ArrayList(10);
        ArrayList hideButtons = new ArrayList(10);
        BUTTON_MAP.forEach((array, list) -> {
            if (this.isMatch(btnArray, (String[])array)) {
                showButtons.addAll(list);
            } else {
                hideButtons.addAll(list);
            }
        });
        buttonsMap.put("showButtons", showButtons);
        buttonsMap.put("hideButtons", hideButtons);
        return buttonsMap;
    }

    private boolean isMatch(String[] btnArray, String[] array) {
        if (btnArray.length != array.length) {
            return false;
        }
        for (int index = 0; index < btnArray.length; ++index) {
            String value = array[index];
            if (value == null || value.equals(btnArray[index])) continue;
            return false;
        }
        return true;
    }

    private void doNewPreview(String taskId, List<PrintTask> taskList, String parentPageId) {
        PrintParam param = this.buildNewPrintParam(taskList, parentPageId);
        if (param.getTaskList().isEmpty()) {
            return;
        }
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        service.doPrint(taskId, (Object)param);
    }

    private PrintTask getPrintTasks(String tplId, List<Object> billIds, String parentPageId) {
        if (billIds != null && tplId != null) {
            PrintTask task = new PrintTask();
            task.setPkIds(billIds);
            task.setFormId("hcss_incomeproofhandle");
            task.setPageId(parentPageId);
            task.setTplId(tplId);
            task.setPrintType("billForm");
            return task;
        }
        return null;
    }

    private PrintParam buildNewPrintParam(List<PrintTask> taskList, String parentPageId) {
        PrintParam param = new PrintParam();
        param.setPageId(parentPageId);
        param.setPrintLang(RequestContext.get().getLang().toString());
        param.setExpType("pdf");
        param.setTaskList(taskList);
        param.setBillFormId("hcss_incomeproofhandle");
        return param;
    }

    private String getIncomeProofBillPdfFilePath(Long billId, String printTplId) {
        PrtAttach prtAttach = this.doIncomeProofBillPdf(Collections.singletonList(billId), printTplId);
        String pathParam = "";
        for (PrtAttach.AttachDetail attachDetail : prtAttach.getAttachDetail()) {
            String fileName = attachDetail.getFileName();
            pathParam = FileHelper.getUploadFileRelativePatch(fileName);
            FileHelper.uploadFileGetUrl(BosPrintServiceHelper.getFileInputStream((String)attachDetail.getFilePath()), fileName, pathParam);
        }
        return pathParam;
    }

    public BaseResult<?> beforeSscOperation(DynamicObject[] dynamicObjects) {
        try {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)11);
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap paramListMap = Maps.newHashMapWithExpectedSize((int)16);
                paramListMap.put("billId", dynamicObject.getLong("id"));
                paramListMap.put("entityNumber", "hcss_incomeproofbill");
                list.add(paramListMap);
            }
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("list", list);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskQueryByBillId", (Object[])new Object[]{paramMap});
            HashMap matchMap = Maps.newHashMapWithExpectedSize((int)16);
            if (ObjectUtils.isNotEmpty((Object)result) && result.get("success").equals("true")) {
                List billTaskMapList;
                Map data = (Map)result.get("data");
                if (ObjectUtils.isNotEmpty((Object)data) && CollectionUtils.isNotEmpty((Collection)(billTaskMapList = (List)data.get("billTaskMapList")))) {
                    for (Map billTaskMap : billTaskMapList) {
                        List taskList = (List)billTaskMap.get("taskList");
                        if (!CollectionUtils.isNotEmpty((Collection)taskList)) continue;
                        matchMap.put((Long)billTaskMap.get("billId"), "1");
                    }
                }
                ArrayList messageList = Lists.newArrayListWithExpectedSize((int)10);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String billIdStr = (String)matchMap.get(dynamicObject.getLong("id"));
                    String billno = dynamicObject.getString("billno");
                    if (!StringUtils.isNotEmpty((CharSequence)billIdStr)) continue;
                    messageList.add(ResManager.loadKDString((String)"{0}\uff1a\u8be5\u4efb\u52a1\u5df2\u8fdb\u5165HR\u5171\u4eab\u4e2d\u5fc3\u5904\u7406\uff0c\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u5982\u6709\u9700\u8981\u8bf7\u8054\u7cfbHR\u5171\u4eab\u4e2d\u5fc3\u7ba1\u7406\u5458\u3002", (String)"IncomeProofBillService_11", (String)"swc-hcss-business", (Object[])new Object[]{billno}));
                }
                if (!messageList.isEmpty()) {
                    return BaseResult.fail((String)((String)messageList.get(0)));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5171\u4eab\u6d41\u7a0b\u6570\u636e\u5f02\u5e38", (Throwable)exception);
        }
        return BaseResult.success(null);
    }

    public List<String> getDownUrls(List<Object> successIds) {
        ArrayList<String> downUrls = new ArrayList<String>(10);
        QFilter filter = new QFilter("id", "in", successIds);
        DynamicObjectCollection billHandleCol = this.queryIncomeProofBillHandleCol("id,datasource", filter, "");
        for (DynamicObject billData : billHandleCol) {
            String name = this.getBillNameByDataSource(billData.getString("datasource"));
            List<Map<String, Object>> attachmentData = this.getAttachmentData(name, billData.getLong("id"));
            attachmentData.forEach(data -> downUrls.add(MapUtils.getString((Map)data, (Object)"url")));
        }
        return downUrls;
    }

    public void sscTaskDeal(DynamicObject[] dataList) {
        try {
            if (dataList != null && dataList.length > 0) {
                HashMap billIdMap = Maps.newHashMapWithExpectedSize((int)16);
                for (DynamicObject data : dataList) {
                    billIdMap.put(data.getLong("id"), Maps.newHashMapWithExpectedSize((int)16));
                }
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("operatorId", RequestContext.get().getCurrUserId());
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"terminateOrDeleteTask", (Object[])new Object[]{dataList[0].getDynamicObjectType().getName(), billIdMap, paramMap});
                LOGGER.info("sscTaskDeal result{}", (Object)result);
            }
        }
        catch (Exception exception) {
            LOGGER.error("afterExecuteOperationTransaction exception\uff1a{}", (Object)exception.getMessage());
        }
    }
}

