/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.service.income;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcss.business.dao.common.ICommonDao;
import kd.swc.hcss.business.dao.common.impl.CommonDaoImpl;
import kd.swc.hcss.business.dao.income.IncomeProofTplDao;
import kd.swc.hcss.business.service.AbstractHcssService;
import kd.swc.hcss.business.util.DaoFactory;
import kd.swc.hcss.business.web.incometpl.AuditOperation;
import kd.swc.hcss.business.web.incometpl.ConfirmChangeOperation;
import kd.swc.hcss.business.web.incometpl.DisEnableOperation;
import kd.swc.hcss.business.web.incometpl.EnableOperation;
import kd.swc.hcss.business.web.incometpl.TplBaseOperation;
import kd.swc.hcss.common.common.IncomeProofTplCommon;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

@HrDomainEntity
public class IncomeProofTplService
extends AbstractHcssService
implements IncomeProofTplCommon {
    private IncomeProofTplDao incomeProofTplDao = DaoFactory.getDao(IncomeProofTplDao.class);
    private ICommonDao commonDao = DaoFactory.getDao(CommonDaoImpl.class);

    public List<String> getEnablePrintTplIds() {
        return this.commonDao.getPrintTplIdsByManagePrintTpl("hcss_incomeproofhandle");
    }

    public Map<Long, DynamicObject> getTplMsgMap(Set<Long> tplIdSet) {
        return this.incomeProofTplDao.getTplMsgMap(tplIdSet);
    }

    public Map<String, Boolean> getIssueTypeMap(DynamicObject tplData) {
        String[] split;
        HashMap<String, Boolean> issueTypeMap = new HashMap<String, Boolean>(16);
        issueTypeMap.put("ispageissue", Boolean.FALSE);
        issueTypeMap.put("iselecissue", Boolean.FALSE);
        String issueType = tplData.getString("issuetype");
        for (String value : split = issueType.split(",")) {
            if (SWCStringUtils.equals((String)"1", (String)value)) {
                issueTypeMap.put("iselecissue", Boolean.TRUE);
            }
            if (!SWCStringUtils.equals((String)"0", (String)value)) continue;
            issueTypeMap.put("ispageissue", Boolean.TRUE);
        }
        return issueTypeMap;
    }

    public DynamicObjectCollection getReceiveWays(DynamicObject tplData) {
        if (tplData == null) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection collection = tplData.getDynamicObjectCollection("receivewayentry");
        return collection == null ? new DynamicObjectCollection() : collection;
    }

    public List<Long> getReceiveWayIds(DynamicObject tplData) {
        DynamicObjectCollection receiveWays = this.getReceiveWays(tplData);
        return receiveWays.stream().map(data -> data.getLong("receiveway.id")).collect(Collectors.toList());
    }

    public DynamicObject getMatchEntryByReceiveWay(Long receiveWayId, DynamicObject incomeTpl) {
        DynamicObjectCollection receiveWays = this.getReceiveWays(incomeTpl);
        return receiveWays.stream().filter(entry -> receiveWayId == null || receiveWayId.equals(entry.getLong("receiveway.id"))).findFirst().orElse(null);
    }

    public DynamicObject getIncomeProofTplById(Long tplId) {
        QFilter filter = new QFilter("id", "=", (Object)tplId);
        DynamicObjectCollection dataCol = this.incomeProofTplDao.queryDataCol("org.id,org.name,status,enable,boid", new QFilter[]{filter});
        if (dataCol.isEmpty()) {
            return null;
        }
        return (DynamicObject)dataCol.get(0);
    }

    public DynamicObjectCollection getIncomeProofTplByIds(List<Long> tplIdList) {
        QFilter filter = new QFilter("id", "in", tplIdList);
        return this.incomeProofTplDao.queryDataCol("enable,status", new QFilter[]{filter});
    }

    public DynamicObject[] getAuditAndEnableOtherDataArrayByOrg(Long org, Long boId) {
        QFilter filter = new QFilter("org.id", "=", (Object)org);
        filter.and(new QFilter("boid", "!=", (Object)boId));
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        return this.incomeProofTplDao.getSaveData("org.id,org.name,enable,status,boid,sourcevid", new QFilter[]{filter, ENABLE_FILTER, AUDIT_FILTER, hisCurrFilter});
    }

    public DynamicObject[] getAuditAndEnableDataArrayByOrg(Long org) {
        QFilter filter = new QFilter("org.id", "=", (Object)org);
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        return this.incomeProofTplDao.getSaveData("org.id,org.name,enable,status,boid,sourcevid", new QFilter[]{filter, ENABLE_FILTER, AUDIT_FILTER, hisCurrFilter});
    }

    public DynamicObject getMatchEntryByReasonAndPrintTpl(DynamicObject incomeTpl, Long reasonId, String printTplId) {
        return incomeTpl.getDynamicObjectCollection("entryentity").stream().filter(entry -> {
            if (printTplId == null || printTplId.equals(entry.getString("printtpl.id"))) {
                DynamicObjectCollection reasonMul = entry.getDynamicObjectCollection("mulreasonentry");
                for (DynamicObject reason : reasonMul) {
                    if (reasonId != null && !reasonId.equals(reason.getLong("fbasedataid.id"))) continue;
                    return true;
                }
            }
            return false;
        }).findFirst().orElse(null);
    }

    public void disableOrEnableBo(List<Long> boIdList, boolean disabled) {
        HisModelController hisModelController = new HisModelController();
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber("hcss_incomeproofscheme");
        hisBaseBo.setBoIdList(boIdList);
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        hisEnableParamBo.setDisabled(disabled);
        hisModelController.disableOrEnableBo(hisEnableParamBo);
    }

    public TplBaseOperation decorator(String operationKey) {
        TplBaseOperation baseOperation = null;
        switch (operationKey) {
            case "enable": {
                baseOperation = new EnableOperation();
                break;
            }
            case "audit": {
                baseOperation = new AuditOperation();
                break;
            }
            case "disable": {
                baseOperation = new DisEnableOperation();
                break;
            }
            case "auditconfirmchange": {
                baseOperation = new ConfirmChangeOperation();
                break;
            }
        }
        return baseOperation;
    }

    public OperationResult invokeOperation(DynamicObject[] dataArray, String opName) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        return opImpl.localInvokeOperation(opName, dataArray, operateOption);
    }
}

