/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.service.income;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcss.business.dao.income.RevenueFieldDao;
import kd.swc.hcss.business.helper.CueHelper;
import kd.swc.hcss.business.helper.FilterHelper;
import kd.swc.hcss.business.helper.FormulaHelper;
import kd.swc.hcss.business.mservice.salarymamager.ISalaryManagerService;
import kd.swc.hcss.business.service.AbstractHcssService;
import kd.swc.hcss.business.util.DaoFactory;
import kd.swc.hcss.business.util.DynamicTransformUtils;
import kd.swc.hcss.business.web.income.IncomeCalGenerator;
import kd.swc.hcss.common.common.RevenueFieldCommon;
import kd.swc.hcss.common.entity.ExpressionDTO;
import kd.swc.hcss.common.entity.RevenueFieldCalResult;
import kd.swc.hcss.common.enums.ExpTypeEnum;
import kd.swc.hcss.common.enums.IncomeValueSourceEnum;
import kd.swc.hcss.common.enums.RevenueFieldEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

@HrDomainEntity
public class RevenueFieldService
extends AbstractHcssService
implements RevenueFieldCommon {
    private RevenueFieldDao revenueFieldDao = DaoFactory.getDao(RevenueFieldDao.class);
    private static final Map<String, List<RevenueFieldEnum>> FIELD_MAP = ImmutableMap.builder().put((Object)IncomeValueSourceEnum.HAND_WORK.getCode(), Collections.emptyList()).put((Object)IncomeValueSourceEnum.STANDARD.getCode(), Collections.singletonList(RevenueFieldEnum.STANDARDITEM)).put((Object)IncomeValueSourceEnum.REVENUE_FIELD.getCode(), Arrays.asList(RevenueFieldEnum.VALUEEXPSHOW, RevenueFieldEnum.DATAROUND, RevenueFieldEnum.CURRENCY, RevenueFieldEnum.EXRATETABLE, RevenueFieldEnum.EXRATEDATE)).put((Object)IncomeValueSourceEnum.CUSTOM.getCode(), Collections.singletonList(RevenueFieldEnum.PLUGPATH)).build();

    public Map<String, List<RevenueFieldEnum>> getFieldMap() {
        return FIELD_MAP;
    }

    public Map<String, String> queryRevenueFieldNameMap(QFilter[] filters) {
        return this.revenueFieldDao.queryRevenueFieldNameMap(filters);
    }

    public DynamicObjectCollection queryRevenueFieldCol(QFilter[] filters, String orderBys) {
        return this.revenueFieldDao.queryDataCol(DynamicTransformUtils.getDynamicPropString("hcss_revenuefield"), filters, orderBys);
    }

    public List<ExpressionDTO> extractMessage(String valueExp) {
        valueExp = valueExp.replaceAll(" ", "");
        return FormulaHelper.extractMessage(valueExp, '[', ']', new HashSet<String>(FormulaHelper.OPERATIONCHARACTER.values()));
    }

    public QFilter getExpressionIdFilter(List<ExpressionDTO> expressionList) {
        Set idSet = expressionList.stream().filter(expression -> ExpTypeEnum.ITEM == expression.getExpTypeEnum()).map(expression -> Long.parseLong(expression.getContent())).collect(Collectors.toSet());
        return new QFilter("id", "in", idSet);
    }

    public String getValueExpShow(String valueExp, Boolean isCheckEnable) {
        DynamicObjectCollection col;
        List<ExpressionDTO> expressionList = this.extractMessage(valueExp);
        QFilter idFilter = this.getExpressionIdFilter(expressionList);
        if (isCheckEnable.booleanValue() && (col = this.revenueFieldDao.queryDataCol("id", new QFilter[]{idFilter, FilterHelper.getDisEnableFilter()})).size() > 0) {
            return "";
        }
        return FormulaHelper.transformExpression(expressionList, this.queryRevenueFieldNameMap(new QFilter[]{idFilter, AUDIT_FILTER}));
    }

    public Map<String, Object> getRevenueFieldCalMap(DynamicObject revenueField, Map<String, Object> editMap) {
        Map<String, Object> map = DynamicTransformUtils.dynamicObjectToMap(revenueField);
        if (editMap != null) {
            map.putAll(editMap);
        }
        return map;
    }

    public BaseResult<List<RevenueFieldCalResult>> calRevenueField(Map<String, Object> dataMap) {
        return IncomeCalGenerator.generateWith(IncomeValueSourceEnum.getNameByCode((String)String.valueOf(dataMap.get("valuesource"))), dataMap);
    }

    public DynamicObjectCollection getStandardItems(Long employeeId, Long standardItemId) {
        BaseResult<DynamicObjectCollection> baseResult = ISalaryManagerService.getInstance().getDecideSalaryByEmployeeId(employeeId, standardItemId);
        return (DynamicObjectCollection)baseResult.getData();
    }

    public Tuple<List<ExpressionDTO>, List<String>> analysis(String valueExp, BiMap<String, String> nameIdMap) {
        List<ExpressionDTO> expressionList = FormulaHelper.extractMessage(valueExp, '[', ']', new HashSet<String>(FormulaHelper.OPERATIONCHARACTER.values()));
        ArrayList<String> errorFieldList = new ArrayList<String>(10);
        ArrayList<String> invalidTextList = new ArrayList<String>(10);
        HashSet<Long> fieldIdSet = new HashSet<Long>(16);
        boolean divisorNotZero = true;
        StringBuilder expression = new StringBuilder();
        int size = expressionList.size();
        for (int index = 0; index < size; ++index) {
            ExpressionDTO expressionDTO = expressionList.get(index);
            if (ExpTypeEnum.ITEM == expressionDTO.getExpTypeEnum()) {
                String field = expressionDTO.getContent();
                String id = (String)nameIdMap.get((Object)field);
                if (SWCStringUtils.isEmpty((String)id)) {
                    errorFieldList.add(field);
                } else {
                    fieldIdSet.add(Long.parseLong(id));
                }
                expression.append('?');
                continue;
            }
            if (ExpTypeEnum.TEXT == expressionDTO.getExpTypeEnum()) {
                String text = expressionDTO.getContent();
                invalidTextList.add(text);
                expression.append('?');
                continue;
            }
            if (ExpTypeEnum.NUM == expressionDTO.getExpTypeEnum()) {
                expression.append('?');
                continue;
            }
            if (ExpTypeEnum.CHARACTER == expressionDTO.getExpTypeEnum()) {
                String content;
                String op = expressionDTO.getContent();
                if (divisorNotZero && index != size - 1 && FormulaHelper.OPERATIONCHARACTER.get("divide").equals(op) && "0".equals(content = expressionList.get(index + 1).getContent())) {
                    divisorNotZero = false;
                }
            }
            expression.append(expressionDTO.getContent());
        }
        ArrayList<String> error = new ArrayList<String>(10);
        if (!invalidTextList.isEmpty()) {
            error.add(CueHelper.splicingCue(ResManager.loadKDString((String)"\u5b58\u5728\u65e0\u6548\u6587\u672c%s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RevenueFieldService_0", (String)"swc-hcss-business", (Object[])new Object[0]), invalidTextList));
        }
        errorFieldList.addAll(this.queryDisEnable(fieldIdSet));
        if (!errorFieldList.isEmpty()) {
            error.add(CueHelper.splicingCue(ResManager.loadKDString((String)"\u6536\u5165\u8bc1\u660e\u9879\u76ee%s\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528,\u8bf7\u4fee\u6539\u3002", (String)"RevenueFieldService_1", (String)"swc-hcss-business", (Object[])new Object[0]), errorFieldList));
        }
        if (!divisorNotZero) {
            error.add(ResManager.loadKDString((String)"\u9664\u6570\u4e0d\u5141\u8bb8\u4e3a0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RevenueFieldService_2", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        BaseResult<List<String>> baseResult = FormulaHelper.validate(expression.toString());
        error.addAll((Collection)baseResult.getData());
        if (error.isEmpty()) {
            return Tuple.create(expressionList, error);
        }
        return Tuple.create((Object)Collections.EMPTY_LIST, error);
    }

    private Collection<String> queryDisEnable(Set<Long> fieldIdSet) {
        if (fieldIdSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        QFilter filter = new QFilter("id", "in", fieldIdSet);
        filter.and(new QFilter("enable", "=", (Object)"0"));
        return this.queryRevenueFieldNameMap(new QFilter[]{filter}).values();
    }
}

