/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.util;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.swc.hcss.business.util.HcssDaoEntity;
import kd.swc.hcss.common.common.HcssCommon;

public class DaoFactory
implements HcssCommon {
    private static final Map<String, String> DAO_MAP = ImmutableMap.builder().put((Object)"AppliyReasonDao", (Object)"kd.swc.hcss.business.dao.income.AppliyReasonDao").put((Object)"IncomeProofBillDao", (Object)"kd.swc.hcss.business.dao.income.IncomeProofBillDao").put((Object)"AgentIncomeProofBillDao", (Object)"kd.swc.hcss.business.dao.income.AgentIncomeProofBillDao").put((Object)"IncomeProofBillIssueLogDao", (Object)"kd.swc.hcss.business.dao.income.IncomeProofBillIssueLogDao").put((Object)"IncomeProofHandleDao", (Object)"kd.swc.hcss.business.dao.income.IncomeProofHandleDao").put((Object)"IncomeProofTplDao", (Object)"kd.swc.hcss.business.dao.income.IncomeProofTplDao").put((Object)"ReceiveWayDao", (Object)"kd.swc.hcss.business.dao.income.ReceiveWayDao").put((Object)"RevenueFieldDao", (Object)"kd.swc.hcss.business.dao.income.RevenueFieldDao").put((Object)"CommonDaoImpl", (Object)"kd.swc.hcss.business.dao.common.impl.CommonDaoImpl").build();

    public static <T> T getDao(Class<T> clazz) {
        if (!clazz.isAnnotationPresent(HcssDaoEntity.class)) {
            throw new KDBizException(new ErrorCode("1000", clazz.getName() + " class is not Annotated by @HcssDaoEntity"), new Object[0]);
        }
        return (T)DaoFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = DAO_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672a\u627e\u5230%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"ServiceFactory_0", (String)"swc-hcss-business", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }
}

