/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.swc.hcss.common.common.HcssCommon;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DynamicTransformUtils
implements HcssCommon {
    private static final Log LOGGER = LogFactory.getLog(DynamicTransformUtils.class);
    private static final List<String> IGNORESYSLIST = Arrays.asList("multilanguagetext", "creator", "createtime", "modifier", "modifiertime", "modifytime", "vid", "sourcevid", "firstbsed", "changebsed", "ismodify", "brfd", "changedescription", "hisversion", "initstatus", "initbatch", "initdatasource");

    public static String getDynamicPropString(String entityName) {
        return DynamicTransformUtils.getDynamicPropString(entityName, null);
    }

    public static String getDynamicPropString(String entityName, Set<String> ignoreKey) {
        Set<String> ignore = DynamicTransformUtils.getIgnoreSet(ignoreKey);
        String propString = null;
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                ArrayList<String> propList = new ArrayList<String>(properties.size());
                for (IDataEntityProperty property : properties) {
                    if (!DynamicTransformUtils.checkFields(property.getName(), ignore) || SWCStringUtils.isEmpty((String)property.getAlias())) continue;
                    propList.add(property.getName());
                }
                propString = String.join((CharSequence)",", propList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entityName:{} error:{}", (Object)entityName, (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25!", (String)"DynamicTransformUtil_1", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return propString == null ? "id" : propString;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy) {
        return DynamicTransformUtils.dynamicObjectToMap(dy, null);
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy, Set<String> ignoreKey) {
        return DynamicTransformUtils.getPropMap(dy, ignoreKey);
    }

    public static Map<String, Object> dynamicObjectsToMap(Collection<DynamicObject> dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            dynamicObjects.forEach(dynamicObject -> {
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                properties.forEach(property -> {
                    if (!resultMap.containsKey(property.getName())) {
                        Object propObj = dynamicObject.get(property);
                        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        resultMap.put(property.getName(), propObj instanceof DynamicObject ? DynamicTransformUtils.getBaseDataValue((DynamicObject)propObj) : mapValue);
                    }
                });
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicObjectsToMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u5931\u8d25!", (String)"DynamicTransformUtil_2", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> dynamicListToMap(Collection<DynamicObject> dyList) {
        return DynamicTransformUtils.dynamicListToMap(dyList, null, true);
    }

    public static List<Map<String, Object>> dynamicListToMap(Collection<DynamicObject> dyList, Set<String> ignoreKey) {
        return DynamicTransformUtils.dynamicListToMap(dyList, ignoreKey, true);
    }

    public static List<Map<String, Object>> dynamicAllPropListToMap(Collection<DynamicObject> dyList) {
        return DynamicTransformUtils.dynamicListToMap(dyList, null, false);
    }

    private static List<Map<String, Object>> dynamicListToMap(Collection<DynamicObject> dyList, Set<String> ignoreKey, boolean isIgnore) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            dyList.forEach(dynamicObject -> {
                Map<String, Object> dyMap = DynamicTransformUtils.getPropMap(dynamicObject, ignoreKey, isIgnore);
                if (!dyMap.isEmpty()) {
                    resultList.add(dyMap);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25!", (String)"DynamicTransformUtil_3", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return resultList;
    }

    public static List<Map<String, Object>> dynamicListToDyMap(List<DynamicObject> dyList) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            IDataEntityType dataEntityType = dyList.get(0).getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            dyList.forEach(dynamicObject -> {
                HashMap<String, Object> resultMap;
                try {
                    resultMap = new HashMap<String, Object>(properties.size());
                    for (IDataEntityProperty property : properties) {
                        Object propObj = dynamicObject.get(property);
                        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        resultMap.put(property.getName(), mapValue);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("getPropMap property", (Throwable)ex);
                    throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25!", (String)"DynamicTransformUtil_4", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
                }
                resultList.add(resultMap);
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToDyMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25!", (String)"DynamicTransformUtil_3", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return resultList;
    }

    private static Object getBaseDataValue(DynamicObject baseDataDy) {
        return baseDataDy.getDataEntityType().getProperties().get((Object)"name") == null ? baseDataDy.get("id") : (baseDataDy.get("name") instanceof ILocaleString ? baseDataDy.getLocaleString("name").getLocaleValue() : baseDataDy.get("name"));
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey) {
        return DynamicTransformUtils.getPropMap(dy, ignoreKey, true);
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey, boolean isIgnore) {
        HashMap<String, Object> resultMap;
        if (dy == null) {
            return Collections.emptyMap();
        }
        Set<String> ignore = DynamicTransformUtils.getIgnoreSet(ignoreKey);
        try {
            IDataEntityType dataEntityType = dy.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            resultMap = new HashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                if (isIgnore && ignore.contains(property.getName())) continue;
                Object propObj = dy.get(property);
                Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                resultMap.put(property.getName(), propObj instanceof DynamicObject ? DynamicTransformUtils.getBaseDataValue((DynamicObject)propObj) : mapValue);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPropMap property", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25!", (String)"DynamicTransformUtil_4", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return resultMap;
    }

    private static Set<String> getIgnoreSet(Set<String> ignoreKey) {
        if (null == ignoreKey || ignoreKey.isEmpty()) {
            ignoreKey = new HashSet<String>(IGNORESYSLIST);
        } else {
            ignoreKey.addAll(IGNORESYSLIST);
        }
        return ignoreKey;
    }

    private static boolean checkFields(String propName, Set<String> ignoreSet) {
        return !ignoreSet.contains(propName) && !propName.endsWith("_id") && !"multilanguagetext".equals(propName);
    }

    public static void setBaseData(String mapKey, DynamicObject baseData, Map<String, Object> map) {
        if (null != baseData) {
            DataEntityPropertyCollection properties = baseData.getDataEntityType().getProperties();
            if (null != properties.get((Object)"name")) {
                map.put(mapKey, baseData.getString("name"));
            }
            if (null != properties.get((Object)"number")) {
                map.put(mapKey + "_number", baseData.getString("number"));
            }
            map.put(mapKey + "_id", baseData.getLong("id"));
        }
    }

    public static void setDynamicObjectMap(Collection<Map<String, Object>> mapList) {
        mapList.forEach(map -> map.forEach((key, value) -> {
            if (map.containsKey(key + "_id")) {
                map.put(key, map.get(key + "_id"));
            }
        }));
    }

    public static void setLocalProp(MainEntityType dataEntityType, DynamicObject baseInstance, Map.Entry<String, Object> keyValue) {
        IDataEntityProperty property = dataEntityType.findProperty(keyValue.getKey());
        if (property != null) {
            Object value = keyValue.getValue();
            if (value instanceof Map) {
                Map langMap = (Map)value;
                LocaleString localeString = LocaleString.fromMap((Map)langMap);
                baseInstance.set(keyValue.getKey(), (Object)localeString);
            } else {
                baseInstance.set(keyValue.getKey(), keyValue.getValue());
            }
            if (property instanceof BasedataProp) {
                baseInstance.set(String.join((CharSequence)"_", keyValue.getKey(), "id"), keyValue.getValue());
            }
        }
    }

    public static String getAllDbPropString(String entityName) {
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                HashSet propList = Sets.newHashSetWithExpectedSize((int)(properties.size() * 2));
                for (IDataEntityProperty property : dataEntityType.getProperties()) {
                    String name = property.getName();
                    if (!property.isDbIgnore() && !"multilanguagetext".equals(property.getName())) {
                        propList.add(name);
                    }
                    if (!(property instanceof PKFieldProp) || !((PKFieldProp)property).isRefId()) continue;
                    propList.add(name.substring(0, name.indexOf("_id")));
                }
                return String.join((CharSequence)",", propList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entitName:{} error:{}", (Object)entityName, (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25!", (String)"DynamicTransformUtil_4", (String)"swc-hcss-business", (Object[])new Object[0])), new Object[0]);
        }
        return "id";
    }

    public static void wrapSameFieldFromSource(DynamicObject target, DynamicObject source, HashSet<String> ignoreFields) {
        DataEntityPropertyCollection targetFields = target.getDynamicObjectType().getProperties();
        BillEntityType sourceType = (BillEntityType)source.getDynamicObjectType();
        targetFields.stream().filter(field -> {
            String fieldName = field.getName();
            return CollectionUtils.isEmpty((Collection)ignoreFields) || !ignoreFields.contains(fieldName);
        }).forEach(field -> {
            String fieldName = field.getName();
            IDataEntityProperty property = sourceType.findProperty(fieldName);
            if (property != null) {
                target.set(fieldName, source.get(fieldName));
            }
        });
    }

    public static DynamicObject getDynamicObjectById(String entityName, Object id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null ? null : new DynamicObject((DynamicObjectType)type, id);
    }
}

