/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hcss.common.dto.income.RevenueCalResultColDTO;
import kd.sdk.swc.hcss.service.api.IIncomeProofCalService;
import kd.swc.hcss.business.web.income.IncomeCalGenerator;
import kd.swc.hcss.common.entity.RevenueFieldCalResult;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.springframework.beans.BeanUtils;

public class CustomCalStrategy
implements IncomeCalGenerator {
    private static final Log log = LogFactory.getLog(CustomCalStrategy.class);

    @Override
    public BaseResult<List<RevenueFieldCalResult>> cal(Map<String, Object> param) {
        String plugPath = (String)param.get("plugpath");
        IIncomeProofCalService service = this.getService(plugPath);
        if (service == null) {
            return BaseResult.success(Collections.singletonList(RevenueFieldCalResult.getInstance()));
        }
        RevenueCalResultColDTO calResultCol = service.calIncomeProof(param);
        if (calResultCol == null) {
            return BaseResult.success(Collections.singletonList(RevenueFieldCalResult.getInstance()));
        }
        Boolean success = calResultCol.getSuccess();
        if (success == null || !success.booleanValue()) {
            Set errors = calResultCol.getErrors();
            String errorString = "";
            if (errors == null) {
                errorString = JSON.toJSONString((Object)errors);
            }
            BaseResult fail = BaseResult.fail((String)errorString);
            fail.setData(Collections.singletonList(RevenueFieldCalResult.getInstance()));
            return fail;
        }
        List calResultList = calResultCol.getCalResultList();
        ArrayList resultList = new ArrayList(calResultList.size());
        calResultList.forEach(calResultDTO -> {
            RevenueFieldCalResult result = new RevenueFieldCalResult(Long.valueOf(0L), "", Integer.valueOf(0), "", null, "");
            BeanUtils.copyProperties((Object)calResultDTO, (Object)result);
            resultList.add(result);
        });
        return BaseResult.success(resultList);
    }

    private IIncomeProofCalService getService(String className) {
        if (SWCStringUtils.isEmpty((String)className)) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"swc-hsas-servicehelper", (Object[])new Object[0]), className));
        }
        try {
            Object service = TypesContainer.createInstance((String)className);
            if (service instanceof IIncomeProofCalService) {
                return (IIncomeProofCalService)service;
            }
        }
        catch (Exception ex) {
            log.info("CustomCal error : {}", (Object)ex.getMessage());
            return null;
        }
        return null;
    }
}

