/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.dao.common.ICommonDao;
import kd.swc.hcss.business.dao.common.impl.CommonDaoImpl;
import kd.swc.hcss.business.helper.CalculatorHelper;
import kd.swc.hcss.business.helper.CueHelper;
import kd.swc.hcss.business.helper.ExchangeConversionHelper;
import kd.swc.hcss.business.service.income.RevenueFieldService;
import kd.swc.hcss.business.util.DaoFactory;
import kd.swc.hcss.business.web.income.IncomeCalGenerator;
import kd.swc.hcss.common.common.HcssCommon;
import kd.swc.hcss.common.entity.ExchangeRateDetailDTO;
import kd.swc.hcss.common.entity.ExpressionDTO;
import kd.swc.hcss.common.entity.RevenueFieldCalResult;
import kd.swc.hcss.common.enums.DataRoundEnum;
import kd.swc.hcss.common.enums.ExpTypeEnum;
import kd.swc.hcss.common.enums.IncomeValueSourceEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;

public class ExpressionCalStrategy
implements IncomeCalGenerator,
HcssCommon {
    private static final Log log = LogFactory.getLog(ExpressionCalStrategy.class);
    private RevenueFieldService revenueFieldService = (RevenueFieldService)DomainFactory.getInstance(RevenueFieldService.class);
    private ICommonDao commonDao = DaoFactory.getDao(CommonDaoImpl.class);

    @Override
    public BaseResult<List<RevenueFieldCalResult>> cal(Map<String, Object> param) {
        try {
            String expression = String.valueOf(param.get("valueexp"));
            List<ExpressionDTO> expressionList = this.revenueFieldService.extractMessage(expression);
            QFilter filter = this.revenueFieldService.getExpressionIdFilter(expressionList);
            DynamicObjectCollection fieldCol = this.revenueFieldService.queryRevenueFieldCol(new QFilter[]{filter}, "");
            HashMap<String, Object> editMap = new HashMap<String, Object>(16);
            editMap.put("employee", param.get("employee"));
            Map<Long, Map> idDataMap = fieldCol.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> this.revenueFieldService.getRevenueFieldCalMap((DynamicObject)data, (Map<String, Object>)editMap)));
            HashMap<Long, List<RevenueFieldCalResult>> resultListMap = new HashMap<Long, List<RevenueFieldCalResult>>(idDataMap.size());
            idDataMap.forEach((id, map) -> {
                List cfr_ignored_0 = (List)resultListMap.put((Long)id, (List<RevenueFieldCalResult>)IncomeCalGenerator.generateWith(IncomeValueSourceEnum.getNameByCode((String)String.valueOf(map.get("valuesource"))), map).getData());
            });
            Long statisticsCurrencyId = (Long)param.get("currency");
            DynamicObject currency = this.getCurrency(statisticsCurrencyId);
            String sign = currency.getString("sign");
            String statisticsCurrencyName = currency.getString("name");
            Integer scale = currency.getInt("amtprecision");
            RevenueFieldCalResult result = new RevenueFieldCalResult(statisticsCurrencyId, statisticsCurrencyName, scale, sign, null, "");
            Long dataRoundId = (Long)param.get("dataround");
            Long exchangeRateTypeId = (Long)param.get("exratetable");
            Date exchangeRateDate = (Date)param.get("exratedate");
            HashSet<String> errorSet = new HashSet<String>(16);
            Map<Long, RevenueFieldCalResult> resultMap = this.exchangeRate(resultListMap, result, dataRoundId, exchangeRateTypeId, exchangeRateDate, errorSet);
            if (!errorSet.isEmpty()) {
                BaseResult fail = BaseResult.fail((String)JSON.toJSONString(errorSet));
                fail.setData(Collections.singletonList(RevenueFieldCalResult.getInstance()));
                return fail;
            }
            expressionList.forEach(expressionDTO -> {
                if (ExpTypeEnum.ITEM == expressionDTO.getExpTypeEnum()) {
                    RevenueFieldCalResult calResult = (RevenueFieldCalResult)resultMap.get(Long.parseLong(expressionDTO.getContent()));
                    BigDecimal value = calResult.getValue();
                    expressionDTO.setContent(value == null ? "0" : value.toPlainString());
                    result.getRateInfoMap().putAll(calResult.getRateInfoMap());
                }
            });
            BigDecimal value = CalculatorHelper.suffixCalculator(expressionList);
            value = value.setScale((int)scale, DataRoundEnum.getRoundingModeByDataRoundId((Long)dataRoundId));
            result.setValue(value);
            result.setShowValue(result.getSign() + (result.getValue() == null ? "" : CueHelper.fmtMicrometer(result.getValue().toPlainString())));
            return BaseResult.success(Collections.singletonList(result));
        }
        catch (Exception e) {
            log.warn("Error cal :", (Throwable)e);
            return BaseResult.success(Collections.singletonList(RevenueFieldCalResult.getInstance()));
        }
    }

    private DynamicObject getCurrency(Long currencyId) {
        return this.commonDao.getCurrency(currencyId);
    }

    private Map<Long, RevenueFieldCalResult> exchangeRate(Map<Long, List<RevenueFieldCalResult>> resultListMap, RevenueFieldCalResult result, Long dataRoundId, Long exchangeRateTypeId, Date conversionDate, Set<String> errorSet) {
        HashMap<Long, RevenueFieldCalResult> resultMap = new HashMap<Long, RevenueFieldCalResult>(resultListMap.size());
        resultListMap.forEach((id, resultList) -> {
            RevenueFieldCalResult clone = result.clone();
            resultList.forEach(calResult -> {
                Long statisticsCurrencyId = clone.getCurrencyId();
                Long currencyId = calResult.getCurrencyId() == 0L ? statisticsCurrencyId : calResult.getCurrencyId();
                Integer scale = clone.getScale();
                BigDecimal calValue = calResult.getValue() == null ? BigDecimal.ZERO : calResult.getValue();
                ExchangeRateInfo rateInfo = ExchangeConversionHelper.getExchangeRateInfo(currencyId, statisticsCurrencyId, exchangeRateTypeId, conversionDate);
                if (rateInfo == null) {
                    if (conversionDate == null) {
                        this.setErrorMsg(errorSet, ResManager.loadKDString((String)"\u6536\u5165\u4fe1\u606f\u6d89\u53ca\u624b\u5de5\u6307\u5b9a\u6c47\u7387\u65e5\u671f\uff0c\u65e0\u6cd5\u81ea\u52a8\u8ba1\u7b97\u3002", (String)"ExpressionCalStrategy_1", (String)"swc-hcss-business", (Object[])new Object[0]));
                    } else {
                        this.setErrorMsg(errorSet, MessageFormat.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230{0}-{1}\u7684\u6c47\u7387\uff0c\u8bf7\u7ef4\u62a4\u6c47\u7387\u3002", (String)"ExpressionCalStrategy_0", (String)"swc-hcss-business", (Object[])new Object[0]), calResult.getCurrencyName(), clone.getCurrencyName()));
                    }
                } else {
                    BigDecimal value = ExchangeConversionHelper.currencyConversion(rateInfo, calValue, scale, DataRoundEnum.getRoundingModeByDataRoundId((Long)dataRoundId));
                    clone.addValue(value);
                    clone.addRateInfo(currencyId, new ExchangeRateDetailDTO(rateInfo, currencyId, statisticsCurrencyId, conversionDate, exchangeRateTypeId));
                }
            });
            resultMap.put((Long)id, clone);
        });
        return resultMap;
    }

    private void setErrorMsg(Set<String> errorSet, String msg) {
        errorSet.add(msg);
    }
}

