/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.helper.CueHelper;
import kd.swc.hcss.business.service.income.RevenueFieldService;
import kd.swc.hcss.business.web.income.IncomeCalGenerator;
import kd.swc.hcss.common.entity.RevenueFieldCalResult;
import kd.swc.hcss.common.util.BaseResult;

public class StandardCalStrategy
implements IncomeCalGenerator {
    private RevenueFieldService revenueFieldService = (RevenueFieldService)DomainFactory.getInstance(RevenueFieldService.class);

    @Override
    public BaseResult<List<RevenueFieldCalResult>> cal(Map<String, Object> param) {
        Long employeeId = (Long)param.get("employee");
        Long standardItemId = (Long)param.get("standarditem");
        DynamicObjectCollection dataCol = this.revenueFieldService.getStandardItems(employeeId, standardItemId);
        ArrayList resultList = new ArrayList(dataCol.size());
        HashMap currencyMap = new HashMap(16);
        dataCol.forEach(data -> {
            BigDecimal amount = new BigDecimal(data.getString("amount"));
            Long currencyId = data.getLong("currency.id");
            amount = amount.setScale(data.getInt("currency.amtprecision"), RoundingMode.HALF_UP);
            RevenueFieldCalResult result = currencyMap.getOrDefault(currencyId, new RevenueFieldCalResult(currencyId, data.getString("currency.name"), Integer.valueOf(data.getInt("currency.amtprecision")), data.getString("currency.sign"), BigDecimal.ZERO, ""));
            result.addValue(amount);
            result.setShowValue(result.getSign() + (result.getValue() == null ? "" : CueHelper.fmtMicrometer(result.getValue().toPlainString())));
            currencyMap.put(currencyId, result);
        });
        resultList.addAll(currencyMap.values());
        return BaseResult.success(resultList);
    }
}

