/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billfieldrule;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.web.income.billfieldrule.IBaseFieldControlRule;

public class EconTplControlRule
implements IBaseFieldControlRule {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    @Override
    public void rule(IncomeBillControlDTO fieldControl, IncomeBillControlDTO changeFieldControl, DynamicObject billData) {
        String fieldKey = changeFieldControl.getFieldKey();
        if ("printtpl".equals(fieldKey)) {
            DynamicObject econTpl = null;
            DynamicObject printTpl = (DynamicObject)changeFieldControl.getValue();
            if (printTpl != null) {
                String printTplId = printTpl.getString("id");
                Long reasonId = billData.getLong("applyreason.id");
                DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
                DynamicObject reasonEntry = this.incomeProofTplService.getMatchEntryByReasonAndPrintTpl(incomeTpl, reasonId, printTplId);
                if (reasonEntry != null) {
                    econTpl = reasonEntry.getDynamicObject("econtpl");
                }
            }
            fieldControl.setValue(econTpl);
        }
    }
}

