/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billfieldrule;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.web.income.billfieldrule.IBaseFieldControlRule;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IssueTypeControlRule
implements IBaseFieldControlRule {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    @Override
    public void rule(IncomeBillControlDTO fieldControl, IncomeBillControlDTO changeFieldControl, DynamicObject billData) {
        String fieldKey = changeFieldControl.getFieldKey();
        if ("isuploadtpl".equals(fieldKey)) {
            Boolean isUpload = (Boolean)changeFieldControl.getValue();
            Boolean bl = isUpload = isUpload == null ? Boolean.FALSE : isUpload;
            if (isUpload.booleanValue()) {
                this.getIncomeBillIssueType(fieldControl, billData);
                fieldControl.addAssociatedControls(new IncomeBillControlDTO("issuetypeflex", null, null, fieldControl.getValue() != null));
                return;
            }
        }
        if ("econtpl".equals(fieldKey)) {
            this.getIncomeBillIssueType(fieldControl, billData);
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("issuetypeflex", null, null, fieldControl.getValue() != null));
            return;
        }
        if ("issuetype".equals(fieldKey)) {
            this.getIncomeBillIssueType(fieldControl, billData);
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("issuenum", 1, null, "0".equals(fieldControl.getValue())));
        }
    }

    private void getIncomeBillIssueType(IncomeBillControlDTO fieldControl, DynamicObject incomeBill) {
        boolean isUpload = incomeBill.getBoolean("isuploadtpl");
        if (isUpload) {
            this.setFieldControlPage(fieldControl);
            return;
        }
        if (incomeBill.getDynamicObject("printtpl") == null) {
            fieldControl.setMust(Boolean.TRUE);
            fieldControl.setEnable(Boolean.FALSE);
            return;
        }
        if (incomeBill.getDynamicObject("econtpl") == null) {
            this.setFieldControlPage(fieldControl);
            return;
        }
        DynamicObject incomeTpl = incomeBill.getDynamicObject("incometpl");
        Map<String, Boolean> issueTypeMap = this.incomeProofTplService.getIssueTypeMap(incomeTpl);
        Boolean isElec = issueTypeMap.getOrDefault("iselecissue", Boolean.FALSE);
        Boolean isPage = issueTypeMap.getOrDefault("ispageissue", Boolean.FALSE);
        if (isPage.booleanValue()) {
            String issueType = incomeBill.getString("issuetype");
            fieldControl.setValue(SWCStringUtils.isEmpty((String)issueType) || "0".equals(issueType) ? "0" : "1");
            fieldControl.setVisible(Boolean.TRUE);
            fieldControl.setMust(Boolean.TRUE);
            fieldControl.setEnable(isElec);
        } else if (isElec.booleanValue()) {
            fieldControl.setValue("1");
            fieldControl.setVisible(Boolean.TRUE);
            fieldControl.setMust(Boolean.TRUE);
            fieldControl.setEnable(Boolean.FALSE);
        }
    }

    private void setFieldControlPage(IncomeBillControlDTO fieldControl) {
        fieldControl.setValue("0");
        fieldControl.setVisible(Boolean.TRUE);
        fieldControl.setMust(Boolean.TRUE);
        fieldControl.setEnable(Boolean.FALSE);
    }
}

