/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billfieldrule;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.web.income.billfieldrule.IBaseFieldControlRule;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PrintTplControlRule
implements IBaseFieldControlRule {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    @Override
    public void rule(IncomeBillControlDTO fieldControl, IncomeBillControlDTO changeFieldControl, DynamicObject billData) {
        String fieldKey = changeFieldControl.getFieldKey();
        if ("applyreason".equals(fieldKey)) {
            DynamicObject applyReason = (DynamicObject)changeFieldControl.getValue();
            if (applyReason == null) {
                return;
            }
            boolean isBillUpload = billData.getBoolean("isuploadtpl");
            if (isBillUpload) {
                fieldControl.setValue(null);
                fieldControl.setVisible(Boolean.FALSE);
                fieldControl.addAssociatedControls(new IncomeBillControlDTO("printtplflex", null, null, Boolean.FALSE));
                return;
            }
            DynamicObject printDy = null;
            DynamicObject reasonEntry = this.getReasonEntry(null, billData);
            boolean isHasEntry = reasonEntry != null;
            DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
            boolean isUpload = incomeTpl.getBoolean("isuploadtpl");
            if (isHasEntry) {
                printDy = reasonEntry.getDynamicObject("printtpl");
            }
            Boolean isVisible = !isUpload || printDy != null;
            fieldControl.setValue(printDy);
            fieldControl.setMust(isVisible);
            fieldControl.setVisible(isVisible);
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("printtplflex", null, null, isVisible));
            return;
        }
        if ("isuploadtpl".equals(fieldKey)) {
            Boolean isUploadTpl = (Boolean)changeFieldControl.getValue();
            isUploadTpl = isUploadTpl == null ? Boolean.FALSE : isUploadTpl;
            fieldControl.setVisible(isUploadTpl == false);
            fieldControl.setMust(isUploadTpl == false);
            if (isUploadTpl.booleanValue()) {
                fieldControl.setValue(null);
            } else {
                DynamicObject printDy = null;
                DynamicObject reasonEntry = this.getReasonEntry(null, billData);
                if (reasonEntry != null) {
                    printDy = reasonEntry.getDynamicObject("printtpl");
                }
                fieldControl.setValue(printDy);
            }
            return;
        }
        if ("printtpl".equals(fieldKey)) {
            boolean isUploadTpl;
            DynamicObject printDy = (DynamicObject)changeFieldControl.getValue();
            String tplDesc = "";
            if (printDy != null) {
                boolean isHasEntry;
                DynamicObject reasonEntry = this.getReasonEntry(printDy.getString("id"), billData);
                boolean bl = isHasEntry = reasonEntry != null;
                if (isHasEntry) {
                    tplDesc = reasonEntry.getString("tpldesc");
                }
            }
            fieldControl.setVisible(!(isUploadTpl = billData.getBoolean("isuploadtpl")));
            fieldControl.setMust(!isUploadTpl);
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("printtplflex", null, null, !isUploadTpl));
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("vectorprinttpl", null, null, printDy != null));
            if (!isUploadTpl) {
                fieldControl.addAssociatedControls(new IncomeBillControlDTO("flextips", null, null, SWCStringUtils.isNotEmpty((String)tplDesc)));
                fieldControl.addAssociatedControls(new IncomeBillControlDTO("labeltips", tplDesc, null, null));
            }
        }
    }

    private DynamicObject getReasonEntry(String printId, DynamicObject billData) {
        Long reasonId = billData.getLong("applyreason.id");
        DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
        return this.incomeProofTplService.getMatchEntryByReasonAndPrintTpl(incomeTpl, reasonId, printId);
    }
}

