/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billfieldrule;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.model.income.IncomeBillControlDTO;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.util.DynamicTransformUtils;
import kd.swc.hcss.business.web.income.billfieldrule.IBaseFieldControlRule;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ReceiveWayControlRule
implements IBaseFieldControlRule {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    @Override
    public void rule(IncomeBillControlDTO fieldControl, IncomeBillControlDTO changeFieldControl, DynamicObject billData) {
        String fieldKey = changeFieldControl.getFieldKey();
        if ("issuetype".equals(fieldKey)) {
            String issueType = (String)changeFieldControl.getValue();
            Boolean isPage = "0".equals(issueType);
            fieldControl.setVisible(isPage);
            fieldControl.setMust(isPage);
            if (isPage.booleanValue()) {
                DynamicObject incomeTpl = billData.getDynamicObject("incometpl");
                boolean isUpload = incomeTpl.getBoolean("isuploadtpl");
                Map<String, Boolean> issueTypeMap = this.incomeProofTplService.getIssueTypeMap(incomeTpl);
                if (isUpload && !issueTypeMap.get("ispageissue").booleanValue()) {
                    fieldControl.setValue(DynamicTransformUtils.getDynamicObjectById("hcss_receiveway", RECEIVEWAY_SITE));
                    return;
                }
                DynamicObjectCollection receiveWays = this.incomeProofTplService.getReceiveWays(incomeTpl);
                if (!receiveWays.isEmpty()) {
                    DynamicObject receiveWayEntry = (DynamicObject)receiveWays.get(0);
                    fieldControl.setValue(receiveWayEntry.getDynamicObject("receiveway"));
                }
            } else {
                fieldControl.setValue(null);
            }
            return;
        }
        if ("receiveway".equals(fieldKey)) {
            DynamicObject receiveWay = (DynamicObject)changeFieldControl.getValue();
            Long receiveId = receiveWay != null ? receiveWay.getLong("id") : 0L;
            Boolean isMail = receiveId.equals(RECEIVEWAY_MAIL);
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("mailinginfo", null, null, isMail, isMail));
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("recipient", isMail != false ? billData.getString("person.name") : null, null, isMail, isMail));
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("recipientphone", isMail != false ? billData.getString("percontact.phone") : null, null, isMail, isMail));
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("recipientaddress", "", null, isMail, isMail));
            String issueType = billData.getString("issuetype");
            Boolean isPage = "0".equals(issueType);
            fieldControl.setVisible(isPage != false && receiveWay != null);
            fieldControl.setMust(isPage != false && receiveWay != null);
            String desc = null;
            DynamicObjectCollection receiveWays = this.incomeProofTplService.getReceiveWays(billData.getDynamicObject("incometpl"));
            fieldControl.setEnable(receiveWays.size() > 1);
            DynamicObject receiveWayEntry = this.incomeProofTplService.getMatchEntryByReceiveWay(receiveId, billData.getDynamicObject("incometpl"));
            if (receiveWayEntry != null) {
                desc = receiveWayEntry.getString("receivewaydesc");
            }
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("receivetips", desc, null, SWCStringUtils.isNotEmpty((String)desc)));
            fieldControl.addAssociatedControls(new IncomeBillControlDTO("issueinfotipsflex", desc, null, SWCStringUtils.isNotEmpty((String)desc)));
        }
    }
}

