/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperationDecorator;
import kd.swc.hcss.common.util.BaseResult;

public class AbandonOperation
extends BaseOperationDecorator {
    private static final Log LOGGER = LogFactory.getLog(AbandonOperation.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public AbandonOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        ArrayList<Long> billIds = new ArrayList<Long>(10);
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        for (DynamicObject billData : billDataArray) {
            if (this.abandonIncomeBill(billData)) {
                billIds.add(billData.getLong("id"));
                continue;
            }
            errorMap.put(billData.getLong("id"), ResManager.loadKDString((String)"\u5e9f\u5f03\u5931\u8d25\uff0c\u6d41\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbandonOperation_0", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        DynamicObject[] billDataSaveArray = this.incomeProofBillService.getSaveIncomeProofBillDataByIds("billno,billstatus,auditstatus,dealstatus,isuploadtpl,ischeck", billIds);
        BaseResult<?> baseResult = super.operation(billDataSaveArray, operationKey);
        if (errorMap.isEmpty()) {
            return baseResult;
        }
        return BaseResult.failMap(errorMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean abandonIncomeBill(DynamicObject billData) {
        try (TXHandle txHandle = TX.requiresNew();){
            String businessKey = billData.getString("id");
            if (WorkflowServiceHelper.inProcess((String)businessKey)) {
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            boolean bl = true;
            return bl;
        }
    }
}

