/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.model.income.IncomeDealCalResultDTO;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperationDecorator;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AutoCalOperation
extends BaseOperationDecorator {
    private static final Log LOGGER = LogFactory.getLog(AutoCalOperation.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public AutoCalOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        for (DynamicObject billData : billDataArray) {
            this.autoCalIncomeInfo(billData);
        }
        return super.operation(billDataArray, operationKey);
    }

    private void autoCalIncomeInfo(DynamicObject billData) {
        String dealStatus = billData.getString("dealstatus");
        boolean isUpload = billData.getBoolean("isuploadtpl");
        if (isUpload || SWCStringUtils.isNotEmpty((String)dealStatus)) {
            return;
        }
        String printTplId = billData.getString("printtpl.id");
        DynamicObjectCollection revenueFieldCol = this.incomeProofBillService.getRevenueFieldCol(printTplId);
        IncomeDealCalResultDTO resultDTO = this.incomeProofBillService.calIncomeInfo(billData, revenueFieldCol, null);
        if (resultDTO == null) {
            return;
        }
        Map<Long, List<String>> resultMap = resultDTO.getResultMap();
        Map<Long, Set<String>> errorMap = resultDTO.getErrorMap();
        ArrayList<Map<String, Object>> fieldMapList = new ArrayList<Map<String, Object>>(resultMap.size());
        for (Map.Entry<Long, List<String>> fieldEntryMap : resultMap.entrySet()) {
            Long revenueFieldId = fieldEntryMap.getKey();
            List<String> resultList = fieldEntryMap.getValue();
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            String calValue = resultList == null ? "" : String.join((CharSequence)",", resultList);
            fieldMap.put("revenuefield", revenueFieldId);
            fieldMap.put("calvalue", calValue);
            fieldMap.put("checkvalue", calValue);
            fieldMap.put("entdescription", this.getErrorString(errorMap.get(revenueFieldId)));
            fieldMapList.add(fieldMap);
        }
        this.incomeProofBillService.setIncomeProofBillIncomeInfoEntry(billData, fieldMapList);
    }

    private String getErrorString(Set<String> errorSet) {
        String errorString = "";
        if (errorSet != null && !errorSet.isEmpty()) {
            errorString = String.join((CharSequence)" ", errorSet);
            LOGGER.info("auto cal is error :{}", (Object)errorString);
            errorString = errorString.length() > 200 ? errorString.substring(0, 200) : errorString;
        }
        return errorString;
    }
}

