/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperationDecorator;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AutoSignOperation
extends BaseOperationDecorator {
    private static final Log LOGGER = LogFactory.getLog(AutoSignOperation.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public AutoSignOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        ArrayList<DynamicObject> signDataList = new ArrayList<DynamicObject>(billDataArray.length);
        for (DynamicObject billData : billDataArray) {
            if (!this.isNeedAutoSign(billData)) continue;
            signDataList.add(billData);
        }
        TXHandle array = signDataList.toArray(new DynamicObject[0]);
        try (TXHandle txHandle = TX.requiresNew();){
            BaseResult<?> result = super.operation((DynamicObject[])array, "signing");
            if (!result.isSuccess()) {
                BaseResult<?> baseResult = result;
                return baseResult;
            }
        }
        for (TXHandle billData : array) {
            this.autoSign((DynamicObject)billData);
        }
        txHandle = TX.requiresNew();
        Throwable throwable = null;
        try {
            BaseResult<?> result = super.operation((DynamicObject[])array, operationKey);
            if (!result.isSuccess()) {
                BaseResult<?> baseResult = result;
                return baseResult;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (txHandle != null) {
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        ArrayList<Throwable> signList = new ArrayList<Throwable>(billDataArray.length);
        for (Throwable billData : array) {
            boolean isSign = this.sign((DynamicObject)billData);
            if (isSign) continue;
            signList.add(billData);
        }
        return super.operation(signList.toArray(new DynamicObject[0]), operationKey);
    }

    private boolean isNeedAutoSign(DynamicObject billData) {
        String billStatus = billData.getString("billstatus");
        String issueType = billData.getString("issuetype");
        return "1".equals(issueType) && "C".equals(billStatus);
    }

    private void autoSign(DynamicObject billData) {
        Long lawEntityId = billData.getLong("lawentity.id");
        BaseResult<SignRespParam> baseResult = this.incomeProofBillService.encontractSign(billData, lawEntityId, true);
        if (baseResult.isSuccess()) {
            SignRespParam data = (SignRespParam)baseResult.getData();
            billData.set("econnumber", (Object)data.getContractNo());
            billData.set("econtfailreason", (Object)"");
        } else {
            String message = baseResult.getMessage();
            message = message.length() > 200 ? message.substring(0, 200) : message;
            billData.set("econtfailreason", (Object)message);
            billData.set("econnumber", (Object)"");
        }
    }

    private boolean sign(DynamicObject billData) {
        if (SWCStringUtils.isNotEmpty((String)billData.getString("econnumber"))) {
            Long lawEntityId = billData.getLong("lawentity.id");
            BaseResult<SignRespParam> baseResult = this.incomeProofBillService.signNew(billData, lawEntityId);
            if (!baseResult.isSuccess()) {
                String message = baseResult.getMessage();
                message = message.length() > 200 ? message.substring(0, 200) : message;
                billData.set("econtfailreason", (Object)message);
                billData.set("econnumber", (Object)"");
            }
            return baseResult.isSuccess();
        }
        return true;
    }
}

