/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.helper.MessageSendHelper;
import kd.swc.hcss.business.service.income.IncomeProofTplService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.SscOperation;
import kd.swc.hcss.common.util.BaseResult;

public class ClaimedOperation
extends SscOperation {
    private IncomeProofTplService incomeProofTplService = (IncomeProofTplService)DomainFactory.getInstance(IncomeProofTplService.class);

    public ClaimedOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> beforeOperation(DynamicObject data, OperateOption option, AbstractFormPlugin plugin) {
        return super.beforeOperation(data, option, plugin);
    }

    @Override
    public BaseResult<?> validator(DynamicObject billDataArray) {
        String dealStatus = billDataArray.getString("dealstatus");
        if ("K".equals(dealStatus)) {
            return BaseResult.success(null);
        }
        return BaseResult.fail((String)ResManager.loadKDString((String)"\u529e\u7406\u72b6\u6001\u4e3a\u201c\u5df2\u5f00\u5177\u201d\uff0c\u624d\u80fd\u901a\u77e5\u9886\u53d6\u3002", (String)"ClaimedOperation_0", (String)"swc-hcss-business", (Object[])new Object[0]));
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        BaseResult<?> baseResult = super.operation(billDataArray, operationKey);
        this.sendMessage(billDataArray);
        return baseResult;
    }

    private void sendMessage(DynamicObject[] billDataArray) {
        HashSet<Long> tplIdSet = new HashSet<Long>(billDataArray.length);
        for (DynamicObject billData : billDataArray) {
            tplIdSet.add(billData.getLong("incometpl.id"));
        }
        Map<Long, DynamicObject> tplMsgMap = this.incomeProofTplService.getTplMsgMap(tplIdSet);
        ArrayList<Long> userList = new ArrayList<Long>(1);
        for (DynamicObject billData : billDataArray) {
            long userId = billData.getLong("creator.id");
            if (userId == 0L) continue;
            userList.add(userId);
            DynamicObject msgTpl = tplMsgMap.get(billData.getLong("incometpl.id"));
            String channel = msgTpl.getString("msgtpl.msgchannel");
            String scene = msgTpl.getString("msgtpl.msgscene");
            String msgTitle = ResManager.loadKDString((String)"\u6536\u5165\u8bc1\u660e\u9886\u53d6\u901a\u77e5", (String)"ClaimedOperation_3", (String)"swc-hcss-business", (Object[])new Object[0]);
            String msgContent = MessageFormat.format(ResManager.loadKDString((String)"{0},\u60a8\u7533\u8bf7\u7684\u6536\u5165\u8bc1\u660e\uff08\u5355\u636e\u7f16\u53f7\uff1a{1}\uff09\u5df2\u5b8c\u6210\u5f00\u5177\u3002\u8bf7\u53ca\u65f6\u9886\u53d6\u3002", (String)"ClaimedOperation_4", (String)"swc-hcss-business", (Object[])new Object[0]), billData.getString("person.name"), billData.getString("billno"));
            MessageSendHelper.sendMessage(scene, userList, Collections.singletonList(channel), "hcss_incomeproofhandle", billData.getLong("id"), msgTitle, msgContent, msgTitle);
            userList.clear();
        }
    }
}

